/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.ql.util;

import ca.uwaterloo.cs.ql.fb.AlgebraOperation;
import ca.uwaterloo.cs.ql.fb.BinarySearch;
import ca.uwaterloo.cs.ql.fb.EdgeSet;
import ca.uwaterloo.cs.ql.fb.NodeSet;
import ca.uwaterloo.cs.ql.fb.RadixSorter;
import ca.uwaterloo.cs.ql.fb.Tuple;
import ca.uwaterloo.cs.ql.fb.TupleList;
import ca.uwaterloo.cs.ql.util.SimRank;

public class SimRankBipartite
extends SimRank {
    TupleList shadow;

    public SimRankBipartite(EdgeSet edgeSet) {
        super(edgeSet);
    }

    private boolean inBipartiteDomain(Tuple tuple) {
        return this.inBipartiteDomain(tuple.getDom(), tuple.getRng());
    }

    private boolean inBipartiteRange(Tuple tuple) {
        return this.inBipartiteRange(tuple.getDom(), tuple.getRng());
    }

    private boolean inBipartiteDomain(int n, int n2) {
        int n3 = 0;
        int n4 = BinarySearch.search(this.graph, n, n3);
        int n5 = BinarySearch.search(this.graph, n2, n3);
        return n4 >= 0 && n5 >= 0;
    }

    private boolean inBipartiteRange(int n, int n2) {
        int n3 = 1;
        int n4 = BinarySearch.search(this.shadow, n, n3);
        int n5 = BinarySearch.search(this.shadow, n2, n3);
        return n4 >= 0 && n5 >= 0;
    }

    protected void initEntryPool(EdgeSet edgeSet) {
        SimRank.Entry entry;
        Tuple tuple;
        int n;
        this.shadow = new TupleList(edgeSet.size());
        RadixSorter.sort(edgeSet.getTupleList(), 1, this.shadow);
        NodeSet nodeSet = AlgebraOperation.domainOf(edgeSet);
        EdgeSet edgeSet2 = AlgebraOperation.crossProduct(nodeSet, nodeSet);
        TupleList tupleList = edgeSet2.getTupleList();
        for (n = 0; n < tupleList.size(); ++n) {
            tuple = tupleList.get(n);
            entry = this.ePool.getEntry(tuple);
            if (entry != null) continue;
            entry = this.ePool.putEntry(tuple);
            entry.outNeighbour = true;
            this.processEntry(entry);
        }
        nodeSet = AlgebraOperation.rangeOf(edgeSet);
        edgeSet2 = AlgebraOperation.crossProduct(nodeSet, nodeSet);
        tupleList = edgeSet2.getTupleList();
        for (n = 0; n < tupleList.size(); ++n) {
            tuple = tupleList.get(n);
            entry = this.ePool.getEntry(tuple);
            if (entry != null) continue;
            entry = this.ePool.putEntry(tuple);
            entry.outNeighbour = false;
            this.processEntry(entry);
        }
    }

    protected void processEntry(SimRank.Entry entry) {
        Tuple tuple;
        int n;
        Tuple tuple2;
        int n2;
        int n3;
        int n4;
        TupleList tupleList;
        if (entry.outNeighbour) {
            tupleList = this.graph;
            n4 = 0;
            n3 = 1;
        } else {
            tupleList = this.shadow;
            n4 = 1;
            n3 = 0;
        }
        int n5 = tupleList.size();
        int n6 = BinarySearch.search(tupleList, entry.elem1, n4);
        int n7 = BinarySearch.search(tupleList, entry.elem2, n4);
        if (n6 < 0 || n7 < 0) {
            return;
        }
        int n8 = 0;
        int n9 = 0;
        for (n2 = n6; n2 < n5 && (tuple2 = tupleList.get(n2)).get(n4) == entry.elem1; ++n2) {
            ++n8;
        }
        for (n = n7; n < n5 && (tuple = tupleList.get(n)).get(n4) == entry.elem2; ++n) {
            ++n9;
        }
        int n10 = n6 + n8;
        int n11 = n7 + n9;
        for (n2 = n6; n2 < n10; ++n2) {
            tuple2 = tupleList.get(n2);
            for (n = n7; n < n11; ++n) {
                tuple = tupleList.get(n);
                SimRank.Entry entry2 = this.ePool.getEntry(tuple2.get(n3), tuple.get(n3));
                if (entry2 != null) continue;
                entry2 = this.ePool.putEntry(tuple2.get(n3), tuple.get(n3));
                entry2.outNeighbour = !entry.outNeighbour;
                this.processEntry(entry2);
            }
        }
    }

    protected void computeEntry(SimRank.Entry entry, int n, int n2) {
        Tuple tuple;
        int n3;
        Tuple tuple2;
        int n4;
        int n5;
        int n6;
        TupleList tupleList;
        if (entry.outNeighbour) {
            tupleList = this.graph;
            n6 = 0;
            n5 = 1;
        } else {
            tupleList = this.shadow;
            n6 = 1;
            n5 = 0;
        }
        int n7 = tupleList.size();
        int n8 = BinarySearch.search(tupleList, entry.elem1, n6);
        int n9 = BinarySearch.search(tupleList, entry.elem2, n6);
        if (n8 < 0 || n9 < 0) {
            return;
        }
        int n10 = 0;
        int n11 = 0;
        for (n4 = n8; n4 < n7 && (tuple2 = tupleList.get(n4)).get(n6) == entry.elem1; ++n4) {
            ++n10;
        }
        for (n3 = n9; n3 < n7 && (tuple = tupleList.get(n3)).get(n6) == entry.elem2; ++n3) {
            ++n11;
        }
        double d = 0.0;
        int n12 = n8 + n10;
        int n13 = n9 + n11;
        for (n4 = n8; n4 < n12; ++n4) {
            tuple2 = tupleList.get(n4);
            for (n3 = n9; n3 < n13; ++n3) {
                tuple = tupleList.get(n3);
                SimRank.Entry entry2 = this.ePool.getEntry(tuple2.get(n5), tuple.get(n5));
                d += entry2.sims[n];
            }
        }
        double d2 = d * this.decayFactor / (double)(n10 * n11);
        entry.sims[n2] = d2 > entry.sims[n] ? d2 : entry.sims[n];
    }
}

