/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.ql.util;

import ca.uwaterloo.cs.ql.fb.AlgebraOperation;
import ca.uwaterloo.cs.ql.fb.BinarySearch;
import ca.uwaterloo.cs.ql.fb.EdgeSet;
import ca.uwaterloo.cs.ql.fb.IDManager;
import ca.uwaterloo.cs.ql.fb.NodeSet;
import ca.uwaterloo.cs.ql.fb.RadixSorter;
import ca.uwaterloo.cs.ql.fb.Tuple;
import ca.uwaterloo.cs.ql.fb.TupleFactory;
import ca.uwaterloo.cs.ql.fb.TupleList;
import ca.uwaterloo.cs.ql.fb.TupleSet;
import java.util.ArrayList;
import java.util.HashMap;

public class SimRank {
    int simCol = 0;
    EntryPool ePool = new EntryPool();
    TupleList graph;
    protected double epsilon = 0.001;
    protected double decayFactor = 0.8;

    public SimRank(EdgeSet edgeSet) {
        this.graph = new TupleList(edgeSet.size());
        RadixSorter.sort(edgeSet.getTupleList(), 0, this.graph);
        this.initEntryPool(edgeSet);
    }

    protected void initEntryPool(EdgeSet edgeSet) {
        NodeSet nodeSet = AlgebraOperation.entityOf(edgeSet);
        EdgeSet edgeSet2 = AlgebraOperation.crossProduct(nodeSet, nodeSet);
        TupleList tupleList = edgeSet2.getTupleList();
        for (int i = 0; i < tupleList.size(); ++i) {
            Entry entry = this.ePool.getEntry(tupleList.get(i));
            if (entry != null) continue;
            entry = this.ePool.putEntry(tupleList.get(i));
            this.processEntry(entry);
        }
    }

    protected void processEntry(Entry entry) {
        Tuple tuple;
        int n;
        Tuple tuple2;
        int n2;
        int n3 = this.graph.size();
        int n4 = BinarySearch.search(this.graph, entry.elem1, 0);
        int n5 = BinarySearch.search(this.graph, entry.elem2, 0);
        if (n4 < 0 || n5 < 0) {
            return;
        }
        int n6 = 0;
        int n7 = 0;
        for (n2 = n4; n2 < n3 && (tuple2 = this.graph.get(n2)).getDom() == entry.elem1; ++n2) {
            ++n6;
        }
        for (n = n5; n < n3 && (tuple = this.graph.get(n)).getDom() == entry.elem2; ++n) {
            ++n7;
        }
        int n8 = n4 + n6;
        int n9 = n5 + n7;
        for (n2 = n4; n2 < n8; ++n2) {
            tuple2 = this.graph.get(n2);
            for (n = n5; n < n9; ++n) {
                tuple = this.graph.get(n);
                Entry entry2 = this.ePool.getEntry(tuple2.getRng(), tuple.getRng());
                if (entry2 != null) continue;
                entry2 = this.ePool.putEntry(tuple2.getRng(), tuple.getRng());
                this.processEntry(entry2);
            }
        }
    }

    public double getDecayFactor() {
        return this.decayFactor;
    }

    public void setDecayFactor(double d) {
        this.decayFactor = d;
    }

    public double querySim(Tuple tuple) {
        Entry entry = this.ePool.getEntry(tuple);
        if (entry != null) {
            return entry.sims[this.simCol];
        }
        return 0.0;
    }

    public TupleSet compute(int n) {
        Entry entry;
        int n2 = 0;
        ArrayList<Entry> arrayList = this.ePool.entryList;
        int n3 = arrayList.size();
        for (int i = 0; i < n; ++i) {
            int n4 = i % 2;
            n2 = (n4 + 1) % 2;
            for (int j = 0; j < n3; ++j) {
                entry = arrayList.get(j);
                if (entry.sims[n4] < 1.0) {
                    this.computeEntry(entry, n4, n2);
                    continue;
                }
                entry.sims[n2] = 1.0;
            }
        }
        this.simCol = n2;
        int[] nArray = new int[3];
        TupleSet tupleSet = new TupleSet(n3);
        for (int i = 0; i < n3; ++i) {
            entry = arrayList.get(i);
            nArray[0] = entry.elem1;
            nArray[1] = entry.elem2;
            nArray[2] = this.stringID(entry.sims[this.simCol]);
            tupleSet.add(TupleFactory.create(nArray, true));
        }
        return tupleSet;
    }

    private int stringID(double d) {
        String string;
        if (d < this.epsilon) {
            d = 0.0;
        }
        if ((string = (double)Math.round(d / this.epsilon) * this.epsilon + "").length() > 5) {
            string = string.substring(0, 5);
        }
        return IDManager.getID(string);
    }

    protected void computeEntry(Entry entry, int n, int n2) {
        Tuple tuple;
        int n3;
        Tuple tuple2;
        int n4;
        int n5 = this.graph.size();
        int n6 = BinarySearch.search(this.graph, entry.elem1, 0);
        int n7 = BinarySearch.search(this.graph, entry.elem2, 0);
        if (n6 < 0 || n7 < 0) {
            return;
        }
        int n8 = 0;
        int n9 = 0;
        for (n4 = n6; n4 < n5 && (tuple2 = this.graph.get(n4)).getDom() == entry.elem1; ++n4) {
            ++n8;
        }
        for (n3 = n7; n3 < n5 && (tuple = this.graph.get(n3)).getDom() == entry.elem2; ++n3) {
            ++n9;
        }
        double d = 0.0;
        int n10 = n6 + n8;
        int n11 = n7 + n9;
        for (n4 = n6; n4 < n10; ++n4) {
            tuple2 = this.graph.get(n4);
            for (n3 = n7; n3 < n11; ++n3) {
                tuple = this.graph.get(n3);
                Entry entry2 = this.ePool.getEntry(tuple2.getRng(), tuple.getRng());
                d += entry2.sims[n];
            }
        }
        double d2 = d * this.decayFactor / (double)(n8 * n9);
        entry.sims[n2] = d2 > entry.sims[n] ? d2 : entry.sims[n];
    }

    static class Entry {
        int elem1;
        int elem2;
        boolean outNeighbour = true;
        double[] sims = new double[2];

        Entry(Tuple tuple) {
            this(tuple.getDom(), tuple.getRng());
        }

        Entry(int n, int n2) {
            this.elem1 = n;
            this.elem2 = n2;
            if (n == n2) {
                this.sims[0] = 1.0;
                this.sims[1] = 1.0;
            } else {
                this.sims[0] = 0.0;
                this.sims[1] = 0.0;
            }
        }
    }

    static class EntryPool {
        int s_index = 0;
        ArrayList<Entry> entryList = new ArrayList(1997);
        HashMap<String, Entry> allStrings = new HashMap(1997, 0.75f);

        EntryPool() {
        }

        Entry putEntry(Tuple tuple) {
            return this.putEntry(tuple.getDom(), tuple.getRng());
        }

        Entry getEntry(Tuple tuple) {
            return this.getEntry(tuple.getDom(), tuple.getRng());
        }

        Entry putEntry(int n, int n2) {
            String string;
            Entry entry;
            if (n > n2) {
                int n3 = n;
                n = n2;
                n2 = n3;
            }
            if ((entry = this.allStrings.get(string = n + ":" + n2)) != null) {
                return entry;
            }
            entry = new Entry(n, n2);
            this.entryList.add(this.s_index, entry);
            this.allStrings.put(string, entry);
            ++this.s_index;
            return entry;
        }

        Entry getEntry(int n, int n2) {
            if (n > n2) {
                int n3 = n;
                n = n2;
                n2 = n3;
            }
            String string = n + ":" + n2;
            return this.allStrings.get(string);
        }
    }
}

