/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.ql.util;

import ca.uwaterloo.cs.ql.fb.BinarySearch;
import ca.uwaterloo.cs.ql.fb.EdgeSet;
import ca.uwaterloo.cs.ql.fb.RadixSorter;
import ca.uwaterloo.cs.ql.fb.Tuple;
import ca.uwaterloo.cs.ql.fb.TupleList;
import ca.uwaterloo.cs.ql.util.SimRank;
import java.util.ArrayList;
import java.util.HashMap;

public class SimInitialization {
    protected Object userData;
    protected TupleList feature;

    public SimInitialization(EdgeSet edgeSet, Object object) {
        this.feature = new TupleList(edgeSet.size());
        RadixSorter.sort(edgeSet.getTupleList(), 0, this.feature);
    }

    public void initialize(SimRank simRank) {
        ArrayList<SimRank.Entry> arrayList = simRank.ePool.entryList;
        int n = simRank.simCol;
        int n2 = arrayList.size();
        for (int i = 0; i < n2; ++i) {
            SimRank.Entry entry = arrayList.get(i);
            if (!(entry.sims[n] < 1.0)) continue;
            entry.sims[0] = this.getInitialSim(entry.elem1, entry.elem2);
            entry.sims[1] = entry.sims[0];
        }
    }

    protected double getInitialSim(int n, int n2) {
        Integer n3;
        Tuple tuple;
        int n4;
        if (n == n2) {
            return 1.0;
        }
        int n5 = this.feature.size();
        int n6 = BinarySearch.search(this.feature, n, 0);
        int n7 = BinarySearch.search(this.feature, n2, 0);
        if (n6 < 0 || n7 < 0) {
            return 0.0;
        }
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>(17);
        for (n4 = n6; n4 < n5 && n == (tuple = this.feature.get(n4)).getDom(); ++n4) {
            n3 = new Integer(tuple.getRng());
            if (hashMap.containsKey(n3)) continue;
            hashMap.put(n3, n3);
        }
        int n8 = 0;
        int n9 = n4 - n6;
        for (n4 = n7; n4 < n5; ++n4) {
            tuple = this.feature.get(n4);
            if (n2 != tuple.getDom()) continue;
            n3 = new Integer(tuple.getRng());
            if (hashMap.containsKey(n3)) {
                ++n8;
                continue;
            }
            ++n9;
        }
        return (double)n8 / (double)n9;
    }
}

