/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.ql.lib;

import ca.uwaterloo.cs.ql.fb.Edge;
import ca.uwaterloo.cs.ql.fb.EdgeSet;
import ca.uwaterloo.cs.ql.fb.IDManager;
import ca.uwaterloo.cs.ql.fb.Tree;
import ca.uwaterloo.cs.ql.interp.Env;
import ca.uwaterloo.cs.ql.interp.Value;
import ca.uwaterloo.cs.ql.lib.BuiltinFunction;
import ca.uwaterloo.cs.ql.lib.FunctionLib;
import ca.uwaterloo.cs.ql.lib.InvocationException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

public class writeDot
extends BuiltinFunction {
    private static boolean registered = false;
    private static StringBuffer indent = new StringBuffer();

    protected writeDot() {
        this.name = "writeDot";
    }

    public static void register(FunctionLib functionLib) {
        if (registered) {
            return;
        }
        registered = true;
        writeDot writeDot2 = new writeDot();
        writeDot2.setType(Void.TYPE);
        Class[] classArray = new Class[]{String.class, EdgeSet.class};
        writeDot2.setParamTypes(classArray);
        functionLib.register(writeDot2);
        writeDot2 = new writeDot();
        writeDot2.setType(Void.TYPE);
        classArray = new Class[]{String.class, EdgeSet.class, EdgeSet.class};
        writeDot2.setParamTypes(classArray);
        functionLib.register(writeDot2);
    }

    public Value invoke(Env env, Value[] valueArray) throws InvocationException {
        if (valueArray.length == 2) {
            return writeDot.action_2(valueArray);
        }
        if (valueArray.length == 3) {
            return writeDot.action_3(valueArray);
        }
        throw new InvocationException("illegal use: " + this.name);
    }

    private static Value action_2(Value[] valueArray) throws InvocationException {
        String string = (String)valueArray[0].objectValue();
        EdgeSet edgeSet = (EdgeSet)valueArray[1].objectValue();
        PrintWriter printWriter = writeDot.getWriter(string);
        writeDot.writeHead(printWriter, string);
        writeDot.writeLinks(printWriter, edgeSet);
        writeDot.writeTail(printWriter);
        printWriter.flush();
        return Value.VOID;
    }

    private static Value action_3(Value[] valueArray) throws InvocationException {
        String string = (String)valueArray[0].objectValue();
        EdgeSet edgeSet = (EdgeSet)valueArray[1].objectValue();
        EdgeSet edgeSet2 = (EdgeSet)valueArray[2].objectValue();
        PrintWriter printWriter = writeDot.getWriter(string);
        Tree tree = new Tree(edgeSet2);
        int[] nArray = tree.getRoots();
        if (nArray.length > 1) {
            throw new InvocationException("multiple roots found by writeDot");
        }
        if (nArray.length == 1) {
            writeDot.writeHead(printWriter, string);
            writeDot.writeLinks(printWriter, edgeSet);
            writeDot.writeClusters(printWriter, tree, nArray[0]);
            printWriter.println();
            writeDot.writeTail(printWriter);
            printWriter.flush();
            return Value.VOID;
        }
        throw new InvocationException("no root found by writeDot");
    }

    private static PrintWriter getWriter(String string) throws InvocationException {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(new File(string));
            return new PrintWriter(fileOutputStream, true);
        }
        catch (IOException iOException) {
            throw new InvocationException(iOException.getMessage());
        }
    }

    private static void writeHead(PrintWriter printWriter, String string) {
        printWriter.println("digraph \"" + string + "\" {");
        writeDot.incrIndent();
        printWriter.println(indent + "size = \"8,6\";");
        printWriter.println();
    }

    private static void writeTail(PrintWriter printWriter) {
        writeDot.decrIndent();
        printWriter.println("}");
    }

    private static void writeLinks(PrintWriter printWriter, EdgeSet edgeSet) {
        Edge[] edgeArray = edgeSet.getAllEdges();
        for (int i = 0; i < edgeArray.length; ++i) {
            Edge edge = edgeArray[i];
            printWriter.println(indent + "\"" + edge.getFrom() + "\"->\"" + edge.getTo() + "\";");
        }
        printWriter.println();
    }

    private static void writeClusters(PrintWriter printWriter, Tree tree, int n) {
        int[] nArray = tree.getChildren(n);
        if (nArray.length > 0) {
            printWriter.println(indent + "subgraph \"cluster_" + n + "\" {");
            writeDot.incrIndent();
            printWriter.println(indent + "label=\"" + IDManager.get(n) + "\";");
            for (int i = 0; i < nArray.length; ++i) {
                writeDot.writeClusters(printWriter, tree, nArray[i]);
            }
            writeDot.decrIndent();
            printWriter.println(indent + "}");
        } else {
            printWriter.println(indent + "\"" + IDManager.get(n) + "\";");
        }
    }

    private static void incrIndent() {
        indent.append("    ");
    }

    private static void decrIndent() {
        int n = indent.length();
        if (n > 0) {
            indent.delete(n - 4, n);
        }
    }
}

