/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.ql.lib;

import ca.uwaterloo.cs.ql.fb.EdgeSet;
import ca.uwaterloo.cs.ql.fb.IDManager;
import ca.uwaterloo.cs.ql.fb.Show;
import ca.uwaterloo.cs.ql.fb.Tree;
import ca.uwaterloo.cs.ql.fb.Tree2;
import ca.uwaterloo.cs.ql.interp.Env;
import ca.uwaterloo.cs.ql.interp.Value;
import ca.uwaterloo.cs.ql.interp.Variable;
import ca.uwaterloo.cs.ql.lib.BuiltinFunction;
import ca.uwaterloo.cs.ql.lib.FunctionLib;
import ca.uwaterloo.cs.ql.lib.InvocationException;

public class showedge
extends BuiltinFunction {
    private Env env;
    private int whichMethod;
    private StringBuffer indent = new StringBuffer();
    private static boolean registered = false;

    protected showedge() {
        this.name = "showedge";
        this.type = Void.TYPE;
        this.paramTypes = new Class[0];
        this.whichMethod = 0;
    }

    public static void register(FunctionLib functionLib) {
        if (registered) {
            return;
        }
        registered = true;
        showedge showedge2 = new showedge();
        showedge2.whichMethod = 0;
        Class[] classArray = new Class[]{String.class, EdgeSet.class};
        showedge2.setParamTypes(classArray);
        functionLib.register(showedge2);
        showedge2 = new showedge();
        showedge2.whichMethod = 1;
        classArray = new Class[]{String.class, EdgeSet.class, Integer.TYPE};
        showedge2.setParamTypes(classArray);
        functionLib.register(showedge2);
        showedge2 = new showedge();
        showedge2.whichMethod = 2;
        classArray = new Class[]{String.class, String.class, EdgeSet.class};
        showedge2.setParamTypes(classArray);
        functionLib.register(showedge2);
        showedge2 = new showedge();
        showedge2.whichMethod = 3;
        classArray = new Class[]{String.class, String.class, EdgeSet.class, Integer.TYPE};
        showedge2.setParamTypes(classArray);
        functionLib.register(showedge2);
    }

    public Value invoke(Env env, Value[] valueArray) throws InvocationException {
        Tree2 tree2;
        this.env = env;
        try {
            EdgeSet edgeSet = this.findContain();
            tree2 = new Tree2(edgeSet);
        }
        catch (InvocationException invocationException) {
            env.out.println("trivial showedge, not implemented");
            return Value.VOID;
        }
        switch (this.whichMethod) {
            case 0: {
                String string = valueArray[0].toString();
                EdgeSet edgeSet = (EdgeSet)valueArray[1].objectValue();
                int n = IDManager.getID(string);
                Tree tree = tree2.getEdgeTree(n, edgeSet);
                EdgeSet edgeSet2 = new EdgeSet();
                this.calculateMultiplicity(n, tree, edgeSet2, true);
                this.printNode(n, tree, edgeSet.getName(), edgeSet2);
                break;
            }
            case 1: {
                String string = valueArray[0].toString();
                EdgeSet edgeSet = (EdgeSet)valueArray[1].objectValue();
                int n = valueArray[2].intValue();
                if (n < 0) {
                    throw new InvocationException("illegal showedge level: " + n);
                }
                int n2 = IDManager.getID(string);
                Tree tree = tree2.getEdgeTree(n2, edgeSet);
                EdgeSet edgeSet3 = new EdgeSet();
                this.calculateMultiplicity(n2, tree, edgeSet3, true);
                this.printNode(n2, tree, edgeSet.getName(), edgeSet3, 0, n);
                break;
            }
            case 2: {
                String string = valueArray[0].toString();
                String string2 = valueArray[1].toString();
                EdgeSet edgeSet = (EdgeSet)valueArray[2].objectValue();
                int n = IDManager.getID(string);
                int n3 = IDManager.getID(string2);
                Tree tree = tree2.getEdgeTree(n, n3, edgeSet);
                int n4 = tree.getRoots()[0];
                EdgeSet edgeSet4 = new EdgeSet();
                this.calculateMultiplicity(n4, tree, edgeSet4, true);
                this.printEdge(n4, tree, true, edgeSet.getName(), edgeSet4);
                break;
            }
            case 3: {
                String string = valueArray[0].toString();
                String string3 = valueArray[1].toString();
                EdgeSet edgeSet = (EdgeSet)valueArray[2].objectValue();
                int n = valueArray[3].intValue();
                if (n < 0) {
                    throw new InvocationException("illegal showedge level: " + n);
                }
                int n5 = IDManager.getID(string);
                int n6 = IDManager.getID(string3);
                Tree tree = tree2.getEdgeTree(n5, n6, edgeSet);
                int n7 = tree.getRoots()[0];
                EdgeSet edgeSet5 = new EdgeSet();
                this.calculateMultiplicity(n7, tree, edgeSet5, true);
                this.printEdge(n7, tree, true, edgeSet.getName(), edgeSet5, 0, n);
            }
        }
        return Value.VOID;
    }

    private EdgeSet findContain() throws InvocationException {
        try {
            Variable variable = this.env.peepScope().lookup("contain");
            if (variable.getType() != EdgeSet.class) {
                throw new InvocationException("contain is not relation");
            }
            return (EdgeSet)variable.getValue().objectValue();
        }
        catch (Exception exception) {
            throw new InvocationException("contain not found");
        }
    }

    private int calculateMultiplicity(int n, Tree tree, EdgeSet edgeSet, boolean bl) {
        int n2 = 0;
        int[] nArray = tree.getChildren(n);
        if (nArray.length == 0) {
            n2 = bl ? 0 : 1;
        } else {
            for (int i = 0; i < nArray.length; ++i) {
                n2 += this.calculateMultiplicity(nArray[i], tree, edgeSet, false);
            }
        }
        edgeSet.add(n, IDManager.getID(n2 + ""));
        return n2;
    }

    private void printNode(int n, Tree tree, String string, EdgeSet edgeSet) {
        String string2 = Show.getAtt(n, edgeSet);
        this.env.out.println(this.indent.toString() + string2 + " : " + IDManager.get(n));
        int[] nArray = tree.getChildren(n);
        if (nArray.length > 0) {
            this.incrIndent();
            for (int i = 0; i < nArray.length; ++i) {
                this.printEdge(nArray[i], tree, false, string, edgeSet);
            }
            this.decrIndent();
        }
    }

    private void printNode(int n, Tree tree, String string, EdgeSet edgeSet, int n2, int n3) {
        String string2 = Show.getAtt(n, edgeSet);
        this.env.out.println(this.indent.toString() + string2 + " : " + IDManager.get(n));
        if (n2 == n3) {
            return;
        }
        int[] nArray = tree.getChildren(n);
        if (nArray.length > 0) {
            this.incrIndent();
            for (int i = 0; i < nArray.length; ++i) {
                this.printEdge(nArray[i], tree, false, string, edgeSet, n2 + 1, n3);
            }
            this.decrIndent();
        }
    }

    private void printEdge(int n, Tree tree, boolean bl, String string, EdgeSet edgeSet) {
        String string2 = bl ? "=>" : IDManager.get(n);
        String string3 = Show.getAtt(n, edgeSet);
        int[] nArray = tree.getChildren(n);
        if (nArray.length == 0) {
            string2 = string2.substring(1, string2.length() - 1);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.indent.toString());
            stringBuffer.append(' ');
            stringBuffer.append("-> (");
            stringBuffer.append(string);
            stringBuffer.append(' ');
            stringBuffer.append(string2);
            stringBuffer.append(')');
            this.env.out.println(stringBuffer.toString());
        } else {
            if (bl) {
                this.env.out.println(this.indent.toString() + string3 + " : " + string2);
            } else {
                int[] nArray2 = IDManager.parse(n);
                if (nArray2.length == 1) {
                    this.env.out.println(this.indent.toString() + string3 + " : " + string2);
                } else {
                    this.env.out.println(this.indent.toString() + string3 + " : => " + string2);
                }
            }
            this.incrIndent();
            for (int i = 0; i < nArray.length; ++i) {
                this.printEdge(nArray[i], tree, false, string, edgeSet);
            }
            this.decrIndent();
        }
    }

    private void printEdge(int n, Tree tree, boolean bl, String string, EdgeSet edgeSet, int n2, int n3) {
        String string2 = bl ? "=>" : IDManager.get(n);
        String string3 = Show.getAtt(n, edgeSet);
        int[] nArray = tree.getChildren(n);
        if (nArray.length == 0) {
            string2 = string2.substring(1, string2.length() - 1);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.indent.toString());
            stringBuffer.append(' ');
            stringBuffer.append("-> (");
            stringBuffer.append(string);
            stringBuffer.append(' ');
            stringBuffer.append(string2);
            stringBuffer.append(')');
            this.env.out.println(stringBuffer.toString());
        } else {
            if (bl) {
                this.env.out.println(this.indent.toString() + string3 + " : " + string2);
            } else {
                int[] nArray2 = IDManager.parse(n);
                if (nArray2.length == 1) {
                    this.env.out.println(this.indent.toString() + string3 + " : " + string2);
                } else {
                    this.env.out.println(this.indent.toString() + string3 + " : => " + string2);
                }
            }
            if (n2 == n3) {
                return;
            }
            this.incrIndent();
            for (int i = 0; i < nArray.length; ++i) {
                this.printEdge(nArray[i], tree, false, string, edgeSet, n2 + 1, n3);
            }
            this.decrIndent();
        }
    }

    private void incrIndent() {
        this.indent.append("|  ");
    }

    private void decrIndent() {
        int n = this.indent.length();
        if (n > 0) {
            this.indent.delete(n - 3, n);
        }
    }
}

