/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.ql.lib;

import ca.uwaterloo.cs.ql.fb.AlgebraOperation;
import ca.uwaterloo.cs.ql.fb.EdgeSet;
import ca.uwaterloo.cs.ql.fb.Factbase;
import ca.uwaterloo.cs.ql.fb.TupleSet;
import ca.uwaterloo.cs.ql.interp.Env;
import ca.uwaterloo.cs.ql.interp.LookupException;
import ca.uwaterloo.cs.ql.interp.Scope;
import ca.uwaterloo.cs.ql.interp.Value;
import ca.uwaterloo.cs.ql.interp.Variable;
import ca.uwaterloo.cs.ql.io.FactbaseReader;
import ca.uwaterloo.cs.ql.io.RSFFileReader;
import ca.uwaterloo.cs.ql.io.TAFileReader;
import ca.uwaterloo.cs.ql.lib.BuiltinFunction;
import ca.uwaterloo.cs.ql.lib.FunctionLib;
import ca.uwaterloo.cs.ql.lib.InvocationException;
import java.io.FileNotFoundException;
import java.util.Enumeration;

public class read
extends BuiltinFunction {
    private static boolean registered = false;

    protected read() {
        this.name = "read";
        this.type = Void.TYPE;
        this.paramTypes = new Class[1];
        this.paramTypes[0] = String.class;
    }

    private read(String string) {
        this();
        this.name = string;
    }

    public static void register(FunctionLib functionLib) {
        if (registered) {
            return;
        }
        registered = true;
        functionLib.register(new read());
        functionLib.register(new read("getta"));
        functionLib.register(new read("getdb"));
    }

    public Value invoke(Env env, Value[] valueArray) throws InvocationException {
        FactbaseReader factbaseReader;
        String string = valueArray[0].toString();
        if (this.name.equals("read")) {
            factbaseReader = this.getReader(string);
        } else if (this.name.equals("getta")) {
            factbaseReader = new TAFileReader();
        } else if (this.name.equals("getdb")) {
            factbaseReader = new RSFFileReader();
        } else {
            throw new InvocationException("illegal use: " + this.name);
        }
        return this.load(env, factbaseReader, string);
    }

    private FactbaseReader getReader(String string) throws InvocationException {
        FactbaseReader factbaseReader;
        if (string.endsWith(".ta")) {
            factbaseReader = new TAFileReader();
        } else if (string.endsWith(".rsf")) {
            factbaseReader = new RSFFileReader();
        } else {
            throw new InvocationException("illegal file: " + string);
        }
        return factbaseReader;
    }

    private Value load(Env env, FactbaseReader factbaseReader, String string) throws InvocationException {
        Factbase factbase;
        try {
            factbase = factbaseReader.read(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new InvocationException(string + " not found");
        }
        Enumeration enumeration = factbase.allSets();
        Scope scope = env.peepScope();
        while (enumeration.hasMoreElements()) {
            Variable variable;
            TupleSet tupleSet = (TupleSet)enumeration.nextElement();
            try {
                variable = scope.lookup(tupleSet.getName());
                if (tupleSet instanceof EdgeSet && variable.getType() == EdgeSet.class) {
                    EdgeSet edgeSet = (EdgeSet)variable.getValue().objectValue();
                    EdgeSet edgeSet2 = (EdgeSet)tupleSet;
                    EdgeSet edgeSet3 = AlgebraOperation.union(edgeSet, edgeSet2);
                    variable.setValue(new Value(edgeSet3));
                    edgeSet3.setName(variable.getName());
                    continue;
                }
                variable.setValue(new Value(tupleSet));
            }
            catch (LookupException lookupException) {
                variable = new Variable(scope, tupleSet.getName(), new Value(tupleSet));
                scope.addVariable(variable);
            }
        }
        return Value.VOID;
    }
}

