/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.ql.lib;

import ca.uwaterloo.cs.ql.fb.EdgeSet;
import ca.uwaterloo.cs.ql.fb.IDManager;
import ca.uwaterloo.cs.ql.fb.Tuple;
import ca.uwaterloo.cs.ql.fb.TupleList;
import ca.uwaterloo.cs.ql.interp.Env;
import ca.uwaterloo.cs.ql.interp.Value;
import ca.uwaterloo.cs.ql.lib.BuiltinFunction;
import ca.uwaterloo.cs.ql.lib.FunctionLib;
import ca.uwaterloo.cs.ql.lib.InvocationException;

public class entropy
extends BuiltinFunction {
    private static boolean registered = false;

    protected entropy() {
        this.name = "entropy";
        this.type = Float.TYPE;
        this.paramTypes = new Class[1];
        this.paramTypes[0] = EdgeSet.class;
    }

    public static void register(FunctionLib functionLib) {
        if (registered) {
            return;
        }
        registered = true;
        functionLib.register(new entropy());
    }

    public Value invoke(Env env, Value[] valueArray) throws InvocationException {
        double d = 0.0;
        EdgeSet edgeSet = (EdgeSet)valueArray[0].objectValue();
        if (edgeSet.size() == 0) {
            d = 0.0;
        } else {
            TupleList tupleList = edgeSet.getTupleList();
            for (int i = 0; i < tupleList.size(); ++i) {
                Tuple tuple = tupleList.get(i);
                try {
                    double d2 = Double.parseDouble(IDManager.get(tuple.getRng()));
                    if (0.0 < d2 && d2 <= 1.0) {
                        d -= d2 * Math.log(d2) / Math.log(2.0);
                    }
                    if (!(d2 < 0.0) && !(d2 > 1.0)) continue;
                    throw new InvocationException("illegal probability " + d2);
                }
                catch (Exception exception) {
                    throw new InvocationException(exception.getMessage());
                }
            }
        }
        return new Value((float)d);
    }
}

