/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.ql.lib;

import ca.uwaterloo.cs.ql.interp.Type;
import ca.uwaterloo.cs.ql.lib.ENT;
import ca.uwaterloo.cs.ql.lib.Function;
import ca.uwaterloo.cs.ql.lib.ID;
import ca.uwaterloo.cs.ql.lib.RegistrationException;
import ca.uwaterloo.cs.ql.lib.aliases;
import ca.uwaterloo.cs.ql.lib.avg;
import ca.uwaterloo.cs.ql.lib.basket;
import ca.uwaterloo.cs.ql.lib.cast;
import ca.uwaterloo.cs.ql.lib.concept;
import ca.uwaterloo.cs.ql.lib.degree;
import ca.uwaterloo.cs.ql.lib.delset;
import ca.uwaterloo.cs.ql.lib.dircontain;
import ca.uwaterloo.cs.ql.lib.echo;
import ca.uwaterloo.cs.ql.lib.edist;
import ca.uwaterloo.cs.ql.lib.entropy;
import ca.uwaterloo.cs.ql.lib.etree;
import ca.uwaterloo.cs.ql.lib.exec;
import ca.uwaterloo.cs.ql.lib.form;
import ca.uwaterloo.cs.ql.lib.getcsv;
import ca.uwaterloo.cs.ql.lib.grep;
import ca.uwaterloo.cs.ql.lib.head;
import ca.uwaterloo.cs.ql.lib.indegree;
import ca.uwaterloo.cs.ql.lib.lattice;
import ca.uwaterloo.cs.ql.lib.level;
import ca.uwaterloo.cs.ql.lib.list;
import ca.uwaterloo.cs.ql.lib.localof;
import ca.uwaterloo.cs.ql.lib.log;
import ca.uwaterloo.cs.ql.lib.max;
import ca.uwaterloo.cs.ql.lib.median;
import ca.uwaterloo.cs.ql.lib.min;
import ca.uwaterloo.cs.ql.lib.name;
import ca.uwaterloo.cs.ql.lib.normalize;
import ca.uwaterloo.cs.ql.lib.numbering;
import ca.uwaterloo.cs.ql.lib.parse;
import ca.uwaterloo.cs.ql.lib.partition;
import ca.uwaterloo.cs.ql.lib.paths;
import ca.uwaterloo.cs.ql.lib.pause;
import ca.uwaterloo.cs.ql.lib.pick;
import ca.uwaterloo.cs.ql.lib.pow;
import ca.uwaterloo.cs.ql.lib.rand;
import ca.uwaterloo.cs.ql.lib.range;
import ca.uwaterloo.cs.ql.lib.reach;
import ca.uwaterloo.cs.ql.lib.read;
import ca.uwaterloo.cs.ql.lib.replace;
import ca.uwaterloo.cs.ql.lib.replaceid;
import ca.uwaterloo.cs.ql.lib.reset;
import ca.uwaterloo.cs.ql.lib.reverse;
import ca.uwaterloo.cs.ql.lib.set;
import ca.uwaterloo.cs.ql.lib.sgcount;
import ca.uwaterloo.cs.ql.lib.show;
import ca.uwaterloo.cs.ql.lib.showedge;
import ca.uwaterloo.cs.ql.lib.showpath;
import ca.uwaterloo.cs.ql.lib.showtree;
import ca.uwaterloo.cs.ql.lib.sim;
import ca.uwaterloo.cs.ql.lib.simBi;
import ca.uwaterloo.cs.ql.lib.sort;
import ca.uwaterloo.cs.ql.lib.source;
import ca.uwaterloo.cs.ql.lib.sqrt;
import ca.uwaterloo.cs.ql.lib.stdev;
import ca.uwaterloo.cs.ql.lib.sum;
import ca.uwaterloo.cs.ql.lib.tail;
import ca.uwaterloo.cs.ql.lib.timing;
import ca.uwaterloo.cs.ql.lib.unbasket;
import ca.uwaterloo.cs.ql.lib.unclosure;
import ca.uwaterloo.cs.ql.lib.write;
import ca.uwaterloo.cs.ql.lib.writeDot;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;

public class FunctionLib {
    private HashMap<String, Object> funcEntries = new HashMap();
    private static FunctionLib singletonLib = new FunctionLib();

    private FunctionLib() {
        pause.register(this);
        ID.register(this);
        ENT.register(this);
        sim.register(this);
        simBi.register(this);
        log.register(this);
        pow.register(this);
        min.register(this);
        max.register(this);
        sum.register(this);
        avg.register(this);
        sqrt.register(this);
        cast.register(this);
        range.register(this);
        stdev.register(this);
        median.register(this);
        head.register(this);
        tail.register(this);
        rand.register(this);
        sort.register(this);
        reverse.register(this);
        entropy.register(this);
        numbering.register(this);
        set.register(this);
        pick.register(this);
        name.register(this);
        form.register(this);
        read.register(this);
        write.register(this);
        delset.register(this);
        localof.register(this);
        reach.register(this);
        getcsv.register(this);
        parse.register(this);
        source.register(this);
        exec.register(this);
        list.register(this);
        aliases.register(this);
        grep.register(this);
        replace.register(this);
        degree.register(this);
        indegree.register(this);
        unclosure.register(this);
        reset.register(this);
        echo.register(this);
        timing.register(this);
        replaceid.register(this);
        show.register(this);
        showtree.register(this);
        showedge.register(this);
        showpath.register(this);
        paths.register(this);
        level.register(this);
        etree.register(this);
        edist.register(this);
        writeDot.register(this);
        basket.register(this);
        unbasket.register(this);
        concept.register(this);
        lattice.register(this);
        normalize.register(this);
        sgcount.register(this);
        partition.register(this);
        dircontain.register(this);
        try {
            this.register("examples.ExampleFunction");
            this.register("tt2", "examples.ExampleFunction");
        }
        catch (RegistrationException registrationException) {
            System.err.println(registrationException.getMessage());
        }
    }

    public static FunctionLib instance() {
        return singletonLib;
    }

    public boolean register(Function function) {
        if (function == null) {
            return false;
        }
        Entry entry = new Entry(function);
        this.putEntry(function.getName(), entry);
        return true;
    }

    public boolean register(String string) throws RegistrationException {
        if (string == null) {
            return false;
        }
        try {
            Class<?> clazz = Class.forName(string);
            Function function = (Function)clazz.newInstance();
            return this.register(function);
        }
        catch (Exception exception) {
            throw new RegistrationException(exception.getMessage());
        }
    }

    public boolean register(String string, String string2) throws RegistrationException {
        if (string == null || string2 == null) {
            return false;
        }
        try {
            Class<?> clazz = Class.forName(string2);
            Function function = (Function)clazz.newInstance();
            function.setName(string);
            return this.register(function);
        }
        catch (Exception exception) {
            throw new RegistrationException(exception.getMessage());
        }
    }

    public String[] getFunctionNames() {
        Set<String> set2 = this.funcEntries.keySet();
        String[] stringArray = new String[set2.size()];
        set2.toArray(stringArray);
        return stringArray;
    }

    private void putEntry(String string, Entry entry) {
        Object object = this.funcEntries.get(string);
        if (object == null) {
            this.funcEntries.put(string, entry);
        } else if (object instanceof Entry) {
            EntryContainer entryContainer = new EntryContainer();
            this.funcEntries.put(string, entryContainer);
            entryContainer.add((Entry)object);
            entryContainer.add(entry);
        } else {
            ((EntryContainer)object).add(entry);
        }
    }

    public Function[] find(String string) {
        Function[] functionArray;
        Object object = this.funcEntries.get(string);
        if (object == null) {
            functionArray = new Function[]{};
        } else if (object instanceof Entry) {
            Entry entry = (Entry)object;
            functionArray = new Function[]{entry.exeFunction};
        } else {
            ArrayList<Entry> arrayList = ((EntryContainer)object).list;
            functionArray = new Function[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                Entry entry = arrayList.get(i);
                functionArray[i] = entry.exeFunction;
            }
        }
        return functionArray;
    }

    public Function find(String string, Class[] classArray) {
        Object object = this.funcEntries.get(string);
        if (object == null) {
            return null;
        }
        if (object instanceof Entry) {
            Entry entry = (Entry)object;
            if (entry.anyParams()) {
                return entry.exeFunction;
            }
            int n = Type.distanceTo(classArray, entry.paramTypes);
            if (n >= 0) {
                return entry.exeFunction;
            }
        } else {
            int n = 1000;
            Entry entry = null;
            ArrayList<Entry> arrayList = ((EntryContainer)object).list;
            Entry entry2 = null;
            for (int i = 0; i < arrayList.size(); ++i) {
                Entry entry3 = arrayList.get(i);
                if (entry3.anyParams()) {
                    entry = entry3;
                    continue;
                }
                int n2 = Type.distanceTo(classArray, entry3.paramTypes);
                if (n2 >= 0) {
                    if (entry2 == null) {
                        entry2 = entry3;
                        n = n2;
                    } else if (n2 < n) {
                        entry2 = entry3;
                        n = n2;
                    }
                }
                if (n2 == 0) break;
            }
            if (entry2 != null) {
                return entry2.exeFunction;
            }
            if (entry != null) {
                return entry.exeFunction;
            }
        }
        return null;
    }

    class EntryContainer {
        ArrayList<Entry> list = new ArrayList(3);

        EntryContainer() {
        }

        void add(Entry entry) {
            this.list.add(entry);
        }
    }

    class Entry {
        Class[] paramTypes;
        Function exeFunction;

        Entry(Function function) {
            this.exeFunction = function;
            this.paramTypes = function.getParamTypes();
        }

        boolean anyParams() {
            return this.paramTypes == null;
        }
    }
}

