/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.ql.lib;

import ca.uwaterloo.cs.ql.interp.Env;
import ca.uwaterloo.cs.ql.interp.Type;
import ca.uwaterloo.cs.ql.interp.Value;
import ca.uwaterloo.cs.ql.lib.InvocationException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;

public abstract class Function {
    protected String name = null;
    protected Class type = Void.TYPE;
    protected Class[] paramTypes = new Class[0];
    private String signature = null;

    protected Function() {
    }

    public String getName() {
        return this.name;
    }

    protected void setName(String string) {
        this.name = string;
    }

    public Class getType() {
        return this.type;
    }

    protected void setType(Class clazz) {
        this.type = clazz;
    }

    public Class[] getParamTypes() {
        return this.paramTypes;
    }

    protected void setParamTypes(Class[] classArray) {
        this.paramTypes = classArray;
    }

    public String getSignature() {
        if (this.signature == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.getName());
            if (this.paramTypes == null) {
                stringBuffer.append("(...)");
            } else {
                stringBuffer.append("(");
                for (int i = 0; i < this.paramTypes.length; ++i) {
                    stringBuffer.append(Type.findName(this.paramTypes[i]));
                    stringBuffer.append(", ");
                }
                if (this.paramTypes.length > 0) {
                    stringBuffer.delete(stringBuffer.length() - 2, stringBuffer.length());
                }
                stringBuffer.append(")");
            }
            this.signature = stringBuffer.toString();
        }
        return this.signature;
    }

    public static String getSignature(String string, Class[] classArray) {
        StringBuffer stringBuffer = new StringBuffer(string);
        if (classArray == null) {
            stringBuffer.append("(...)");
        } else {
            stringBuffer.append("(");
            for (int i = 0; i < classArray.length; ++i) {
                stringBuffer.append(Type.findName(classArray[i]));
                stringBuffer.append(", ");
            }
            if (classArray.length > 0) {
                stringBuffer.delete(stringBuffer.length() - 2, stringBuffer.length());
            }
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    public String synopsis() {
        return Type.findName(this.getType()) + " " + this.getSignature();
    }

    public String usage() {
        String string = null;
        String string2 = System.getProperty("ql.info");
        if (string2 != null) {
            try {
                String string3;
                StringBuffer stringBuffer = new StringBuffer();
                File file = new File(string2, this.name);
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                while ((string3 = bufferedReader.readLine()) != null) {
                    stringBuffer.append("\n");
                    stringBuffer.append(string3);
                }
                bufferedReader.close();
                string = stringBuffer.toString();
            }
            catch (FileNotFoundException fileNotFoundException) {
                string = null;
            }
            catch (IOException iOException) {
                string = null;
            }
        }
        return string;
    }

    public abstract Value invoke(Env var1, Value[] var2) throws InvocationException;
}

