/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.ql.interp.select;

import ca.uwaterloo.cs.ql.fb.NodeSet;
import ca.uwaterloo.cs.ql.fb.TupleList;
import ca.uwaterloo.cs.ql.fb.TupleSet;
import ca.uwaterloo.cs.ql.interp.Env;
import ca.uwaterloo.cs.ql.interp.ErrorMessage;
import ca.uwaterloo.cs.ql.interp.EvaluationException;
import ca.uwaterloo.cs.ql.interp.ExpressionNode;
import ca.uwaterloo.cs.ql.interp.Operation;
import ca.uwaterloo.cs.ql.interp.Operator;
import ca.uwaterloo.cs.ql.interp.TypeOperation;
import ca.uwaterloo.cs.ql.interp.Value;
import ca.uwaterloo.cs.ql.interp.ValueMath;
import ca.uwaterloo.cs.ql.interp.select.SelectContextNode;
import java.util.regex.PatternSyntaxException;

public class SelectRelationalExpressionNode
extends SelectContextNode {
    int op;
    ExpressionNode left;
    ExpressionNode right;

    public SelectRelationalExpressionNode(int n, ExpressionNode expressionNode, ExpressionNode expressionNode2) {
        this.op = n;
        this.left = expressionNode;
        this.right = expressionNode2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.left.toString());
        stringBuffer.append(' ');
        stringBuffer.append(Operator.key(this.op));
        stringBuffer.append(' ');
        stringBuffer.append(this.right.toString());
        return stringBuffer.toString();
    }

    public void propagate(Env env, Object object) throws EvaluationException {
        this.left.propagate(env, object);
        this.right.propagate(env, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TupleSet evaluate(Env env, TupleSet tupleSet) throws EvaluationException {
        if (tupleSet.size() == 0) {
            return tupleSet;
        }
        try {
            this.left.propagate(env, this);
            this.right.propagate(env, this);
            if (this.op == 8) {
                TupleSet tupleSet2 = this.evalSetMembership(env, tupleSet);
                return tupleSet2;
            }
            TupleSet tupleSet3 = this.evalRelationalMath(env, tupleSet);
            return tupleSet3;
        }
        finally {
            this.setTuple(null);
            this.left.propagate(env, null);
            this.right.propagate(env, null);
        }
    }

    private TupleSet evalSetMembership(Env env, TupleSet tupleSet) throws EvaluationException {
        Value value = this.right.evaluate(env);
        Object object = value.objectValue();
        if (!(object instanceof NodeSet)) {
            throw new EvaluationException(this.right, "not a set");
        }
        NodeSet nodeSet = (NodeSet)object;
        TupleSet tupleSet2 = tupleSet.newSet();
        TupleList tupleList = tupleSet.getTupleList();
        int n = tupleList.size();
        for (int i = 0; i < n; ++i) {
            this.setTuple(tupleList.get(i));
            Value value2 = this.left.evaluate(env);
            if (value2 == Value.VOID || !nodeSet.contain(value2.toString())) continue;
            tupleSet2.add(this.getTuple());
        }
        return tupleSet2;
    }

    private TupleSet evalRelationalMath(Env env, TupleSet tupleSet) throws EvaluationException {
        Operation operation = null;
        TupleSet tupleSet2 = tupleSet.newSet();
        TupleList tupleList = tupleSet.getTupleList();
        int n = tupleList.size();
        for (int i = 0; i < n; ++i) {
            Value value;
            this.setTuple(tupleList.get(i));
            Value value2 = this.left.evaluate(env);
            Value value3 = this.right.evaluate(env);
            if (value2 == Value.VOID || value3 == Value.VOID) continue;
            try {
                value = ValueMath.eval(this.op, value2, value3);
                if (!value.booleanValue()) continue;
                tupleSet2.add(this.getTuple());
                continue;
            }
            catch (PatternSyntaxException patternSyntaxException) {
                throw new EvaluationException(this, patternSyntaxException.getMessage());
            }
            catch (EvaluationException evaluationException) {
                try {
                    if (operation == null) {
                        operation = this.getOperation(value2, value3);
                    }
                    if (!(value = operation.eval(this.op, value2, value3)).booleanValue()) continue;
                    tupleSet2.add(this.getTuple());
                    continue;
                }
                catch (Exception exception) {
                    throw new EvaluationException(this, exception.getMessage());
                }
            }
        }
        return tupleSet2;
    }

    private Operation getOperation(Value value, Value value2) throws EvaluationException {
        TypeOperation typeOperation = TypeOperation.analyze(this.op, value.getType(), value2.getType());
        if (typeOperation != null) {
            try {
                return typeOperation.getOperation();
            }
            catch (Exception exception) {
                throw new EvaluationException(this, exception.getMessage());
            }
        }
        String string = ErrorMessage.errUnsupportedOperation(this.op, value.getType(), value2.getType());
        throw new EvaluationException(this, string);
    }
}

