/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.ql.interp.select;

import ca.uwaterloo.cs.ql.fb.EdgeSet;
import ca.uwaterloo.cs.ql.fb.NodeSet;
import ca.uwaterloo.cs.ql.fb.Tuple;
import ca.uwaterloo.cs.ql.fb.TupleFactory;
import ca.uwaterloo.cs.ql.fb.TupleSet;
import ca.uwaterloo.cs.ql.interp.Env;
import ca.uwaterloo.cs.ql.interp.EvaluationException;
import ca.uwaterloo.cs.ql.interp.select.ColumnNode;
import ca.uwaterloo.cs.ql.interp.select.SelectConditionNode;
import java.util.ArrayList;

public class SelectProjectionNode
extends SelectConditionNode {
    ArrayList columnList;

    public SelectProjectionNode(ArrayList arrayList) {
        this.columnList = arrayList;
    }

    public void propagate(Env env, Object object) throws EvaluationException {
        for (int i = 0; i < this.columnList.size(); ++i) {
            ColumnNode columnNode = (ColumnNode)this.columnList.get(i);
            columnNode.propagate(env, object);
        }
    }

    public TupleSet evaluate(Env env, TupleSet tupleSet) throws EvaluationException {
        TupleSet tupleSet2;
        int[] nArray = new int[this.columnList.size()];
        for (int i = 0; i < this.columnList.size(); ++i) {
            ColumnNode columnNode = (ColumnNode)this.columnList.get(i);
            nArray[i] = columnNode.evaluate(env).intValue();
        }
        switch (nArray.length) {
            case 1: {
                tupleSet2 = new NodeSet(tupleSet.size());
                break;
            }
            case 2: {
                tupleSet2 = new EdgeSet(tupleSet.size());
                break;
            }
            default: {
                tupleSet2 = new TupleSet(tupleSet.size());
            }
        }
        for (int i = 0; i < tupleSet.size(); ++i) {
            try {
                Tuple tuple = tupleSet.get(i);
                tupleSet2.add(TupleFactory.create(tuple.get(nArray), false));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        tupleSet2.removeDuplicates();
        return tupleSet2;
    }

    public String toString() {
        ColumnNode columnNode = (ColumnNode)this.columnList.get(0);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(columnNode);
        for (int i = 1; i < this.columnList.size(); ++i) {
            columnNode = (ColumnNode)this.columnList.get(i);
            stringBuffer.append(", ");
            stringBuffer.append(columnNode);
        }
        return stringBuffer.toString();
    }
}

