/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.ql.interp.select;

import ca.uwaterloo.cs.ql.fb.Tuple;
import ca.uwaterloo.cs.ql.fb.TupleSet;
import ca.uwaterloo.cs.ql.interp.Env;
import ca.uwaterloo.cs.ql.interp.ErrorMessage;
import ca.uwaterloo.cs.ql.interp.EvaluationException;
import ca.uwaterloo.cs.ql.interp.ExpressionNode;
import ca.uwaterloo.cs.ql.interp.Value;
import ca.uwaterloo.cs.ql.interp.select.SelectConditionNode;
import ca.uwaterloo.cs.ql.interp.select.SelectContext;
import ca.uwaterloo.cs.ql.interp.select.SelectTupleNode;

public class SelectExpressionNode
extends ExpressionNode
implements SelectContext {
    ExpressionNode exp;
    SelectConditionNode cond;
    private Tuple catchedTuple;

    public SelectExpressionNode(ExpressionNode expressionNode, SelectConditionNode selectConditionNode) {
        this.exp = expressionNode;
        this.cond = selectConditionNode;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.exp.toString());
        stringBuffer.append('[');
        stringBuffer.append(this.cond.toString());
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public Tuple getTuple() {
        return this.catchedTuple;
    }

    public void setTuple(Tuple tuple) {
        this.catchedTuple = tuple;
    }

    public void propagate(Env env, Object object) throws EvaluationException {
        this.exp.propagate(env, object);
        this.cond.propagate(env, object);
    }

    public Value evaluate(Env env) throws EvaluationException {
        Value value = this.exp.evaluate(env);
        if (value.objectValue() instanceof TupleSet) {
            TupleSet tupleSet = (TupleSet)value.objectValue();
            if (this.cond instanceof SelectTupleNode) {
                return new Value(((SelectTupleNode)this.cond).evaluate(tupleSet));
            }
            TupleSet tupleSet2 = this.cond.evaluate(env, tupleSet);
            if (tupleSet.hasName()) {
                tupleSet2 = (TupleSet)tupleSet2.clone();
            }
            return new Value(tupleSet2);
        }
        String string = ErrorMessage.errIllegalExpression(value.getType(), TupleSet.class);
        throw new EvaluationException(this.exp, string);
    }
}

