/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.ql.interp.select;

import ca.uwaterloo.cs.ql.fb.IDManager;
import ca.uwaterloo.cs.ql.fb.Tuple;
import ca.uwaterloo.cs.ql.interp.Env;
import ca.uwaterloo.cs.ql.interp.ErrorMessage;
import ca.uwaterloo.cs.ql.interp.EvaluationException;
import ca.uwaterloo.cs.ql.interp.ExpressionNode;
import ca.uwaterloo.cs.ql.interp.Value;
import ca.uwaterloo.cs.ql.interp.select.SelectContext;

public class ColumnNode
extends ExpressionNode {
    int col;
    String numSign = null;
    boolean positive = true;
    SelectContext context;

    public ColumnNode() {
        this.numSign = "#";
    }

    public ColumnNode(int n) {
        this.col = n;
    }

    public int getColumn() {
        return this.col;
    }

    public void setPositive(boolean bl) {
        this.positive = bl;
    }

    public void propagate(Env env, Object object) throws EvaluationException {
        if (object == null) {
            this.context = null;
            return;
        }
        if (object instanceof SelectContext) {
            this.context = (SelectContext)object;
        }
    }

    public Value evaluate(Env env) throws EvaluationException {
        if (this.numSign == null) {
            if (this.positive) {
                if (this.context == null) {
                    return new Value(this.col);
                }
                Tuple tuple = this.context.getTuple();
                if (tuple == null) {
                    throw new EvaluationException(this, ErrorMessage.errNotInterpretable(this.toString()));
                }
                if (this.col < tuple.size()) {
                    String string = IDManager.get(tuple.get(this.col));
                    if (string == null) {
                        return Value.VOID;
                    }
                    return new Value(string);
                }
                throw new EvaluationException(this, ErrorMessage.errIndexOutOfBounds(this.col, tuple.size()));
            }
            if (this.context == null) {
                return new Value(0 - this.col);
            }
            Tuple tuple = this.context.getTuple();
            if (tuple == null) {
                throw new EvaluationException(this, ErrorMessage.errNotInterpretable(this.toString()));
            }
            if (this.col < tuple.size()) {
                String string = IDManager.get(tuple.get(tuple.size() - 1 - this.col));
                if (string == null) {
                    return Value.VOID;
                }
                return new Value(string);
            }
            throw new EvaluationException(this, ErrorMessage.errIndexOutOfBounds(tuple.size() - 1 - this.col, tuple.size()));
        }
        if (this.context == null) {
            return new Value(this.numSign);
        }
        Tuple tuple = this.context.getTuple();
        if (tuple == null) {
            return new Value(0);
        }
        return new Value(tuple.size());
    }

    public String toString() {
        if (this.numSign == null) {
            if (this.positive) {
                return "&" + this.col;
            }
            return "&-" + this.col;
        }
        return "&#";
    }
}

