/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.ql.interp.select;

import ca.uwaterloo.cs.ql.fb.EdgeSet;
import ca.uwaterloo.cs.ql.fb.Tuple;
import ca.uwaterloo.cs.ql.interp.Env;
import ca.uwaterloo.cs.ql.interp.ErrorMessage;
import ca.uwaterloo.cs.ql.interp.EvaluationException;
import ca.uwaterloo.cs.ql.interp.LookupException;
import ca.uwaterloo.cs.ql.interp.Value;
import ca.uwaterloo.cs.ql.interp.Variable;
import ca.uwaterloo.cs.ql.interp.select.ColumnNode;
import ca.uwaterloo.cs.ql.interp.select.SelectContext;

public class ColumnAttributeNode
extends ColumnNode {
    String attName;
    EdgeSet attSet;
    SelectContext context;

    public ColumnAttributeNode(int n, String string) {
        super(n);
        this.attName = string;
    }

    public void propagate(Env env, Object object) throws EvaluationException {
        if (object == null) {
            this.attSet = null;
            this.context = null;
            return;
        }
        if (object instanceof SelectContext) {
            this.context = (SelectContext)object;
            try {
                String string = "@" + this.attName;
                Variable variable = env.lookup(string);
                if (variable.getType() != EdgeSet.class) {
                    throw new EvaluationException(this, "attribute was not eset: " + string);
                }
                this.attSet = (EdgeSet)variable.getValue().objectValue();
            }
            catch (LookupException lookupException) {
                throw new EvaluationException(this, lookupException.getMessage());
            }
        }
    }

    public Value evaluate(Env env) throws EvaluationException {
        Tuple tuple = this.context.getTuple();
        if (this.col < tuple.size()) {
            String string = this.attSet.getAttribute(tuple.get(this.col));
            if (string == null) {
                return Value.VOID;
            }
            return new Value(string);
        }
        throw new EvaluationException(this, ErrorMessage.errIndexOutOfBounds(this.col, tuple.size()));
    }

    public String toString() {
        return "&" + this.col + "." + this.attName;
    }
}

