/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.ql.interp.op;

import ca.uwaterloo.cs.ql.fb.AlgebraOperation;
import ca.uwaterloo.cs.ql.fb.NodeSet;
import ca.uwaterloo.cs.ql.fb.TupleSet;
import ca.uwaterloo.cs.ql.interp.ErrorMessage;
import ca.uwaterloo.cs.ql.interp.Operation;
import ca.uwaterloo.cs.ql.interp.OperationException;
import ca.uwaterloo.cs.ql.interp.Value;

public class TupleSetOperation
extends Operation {
    public Value eval(int n, Value value) throws OperationException {
        TupleSet tupleSet = (TupleSet)value.objectValue();
        switch (n) {
            case 27: {
                return new Value(tupleSet.size());
            }
            case 32: {
                return new Value(AlgebraOperation.id(tupleSet));
            }
            case 33: {
                return new Value(AlgebraOperation.inverse(tupleSet));
            }
            case 36: {
                return new Value(AlgebraOperation.entityOf(tupleSet));
            }
            case 34: {
                return new Value(AlgebraOperation.domainOf(tupleSet));
            }
            case 35: {
                return new Value(AlgebraOperation.rangeOf(tupleSet));
            }
        }
        throw new OperationException(ErrorMessage.errUnsupportedOperation(n, value.getType()));
    }

    public Value eval(int n, Value value, Value value2) throws OperationException {
        if (n == 8) {
            TupleSet tupleSet = (TupleSet)value2.objectValue();
            if (tupleSet instanceof NodeSet) {
                return new Value(((NodeSet)tupleSet).contain(value.toString()));
            }
        } else {
            TupleSet tupleSet = (TupleSet)value.objectValue();
            TupleSet tupleSet2 = (TupleSet)value2.objectValue();
            switch (n) {
                case 12: {
                    return new Value(AlgebraOperation.union(tupleSet, tupleSet2));
                }
                case 13: {
                    return new Value(AlgebraOperation.difference(tupleSet, tupleSet2));
                }
                case 16: {
                    return new Value(AlgebraOperation.composition(tupleSet, tupleSet2));
                }
                case 15: {
                    return new Value(AlgebraOperation.composition(tupleSet, tupleSet2));
                }
                case 17: {
                    return new Value(AlgebraOperation.compositionRel(tupleSet, tupleSet2));
                }
                case 14: {
                    return new Value(AlgebraOperation.intersection(tupleSet, tupleSet2));
                }
            }
        }
        throw new OperationException(ErrorMessage.errUnsupportedOperation(n, value.getType(), value2.getType()));
    }
}

