/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.ql.interp;

import ca.uwaterloo.cs.ql.interp.Env;
import ca.uwaterloo.cs.ql.interp.EvaluationException;
import ca.uwaterloo.cs.ql.interp.ExpressionNode;
import ca.uwaterloo.cs.ql.interp.StatementNode;
import ca.uwaterloo.cs.ql.interp.Value;

public class WhileStatementNode
extends StatementNode {
    ExpressionNode expNode;
    StatementNode bodyNode;

    public WhileStatementNode(ExpressionNode expressionNode, StatementNode statementNode) {
        this.expNode = expressionNode;
        this.bodyNode = statementNode;
    }

    public Value evaluate(Env env) throws EvaluationException {
        block2: {
            Value value;
            do {
                Value value2;
                if ((value2 = this.expNode.evaluate(env)).getType() != Boolean.TYPE) {
                    throw new EvaluationException(this.expNode, "not boolean");
                }
                if (!value2.booleanValue()) break block2;
            } while ((value = this.bodyNode.evaluate(env)) == Value.EVAL);
            return value;
        }
        return Value.EVAL;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getIndent());
        stringBuffer.append("while");
        stringBuffer.append('(');
        stringBuffer.append(this.expNode);
        stringBuffer.append(')');
        stringBuffer.append("\n");
        stringBuffer.append(this.bodyNode);
        return stringBuffer.toString();
    }
}

