/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.ql.interp;

import ca.uwaterloo.cs.ql.interp.Env;
import ca.uwaterloo.cs.ql.interp.ErrorMessage;
import ca.uwaterloo.cs.ql.interp.EvalName;
import ca.uwaterloo.cs.ql.interp.EvaluationException;
import ca.uwaterloo.cs.ql.interp.ExpressionNode;
import ca.uwaterloo.cs.ql.interp.LookupException;
import ca.uwaterloo.cs.ql.interp.Value;
import ca.uwaterloo.cs.ql.interp.Variable;
import ca.uwaterloo.cs.ql.lib.Function;
import ca.uwaterloo.cs.ql.lib.InvocationException;

public class VariableNode
extends ExpressionNode
implements EvalName {
    String name;

    public VariableNode(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void propagate(Env env, Object object) throws EvaluationException {
    }

    public Value evaluate(Env env) throws EvaluationException {
        try {
            Variable variable = env.lookup(this.name);
            if (variable.getValue() == null) {
                throw new EvaluationException(this, ErrorMessage.errUnresolvable(this.name));
            }
            return variable.getValue();
        }
        catch (LookupException lookupException) {
            try {
                Class[] classArray = new Class[]{};
                Value[] valueArray = new Value[]{};
                Function function = env.lookupFunction(this.name, classArray);
                try {
                    return function.invoke(env, valueArray);
                }
                catch (InvocationException invocationException) {
                    throw new EvaluationException(this, invocationException.getMessage());
                }
            }
            catch (LookupException lookupException2) {
                throw new EvaluationException(this, lookupException.getMessage());
            }
        }
    }

    public String evalName(Env env) throws EvaluationException {
        return this.name;
    }

    public String toString() {
        return this.name;
    }
}

