/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.ql.interp;

import ca.uwaterloo.cs.ql.fb.TupleSet;
import ca.uwaterloo.cs.ql.interp.Type;
import java.io.PrintStream;

public class Value {
    Object val;
    Class primitiveType;
    public static final Value VOID = new Value();
    public static final Value EVAL = new Value();

    protected Value() {
        this.val = new Object();
        this.primitiveType = null;
    }

    public Value(int n) {
        this.val = new Integer(n);
        this.primitiveType = Integer.TYPE;
    }

    public Value(float f) {
        this.val = new Float(f);
        this.primitiveType = Float.TYPE;
    }

    public Value(boolean bl) {
        this.val = new Boolean(bl);
        this.primitiveType = Boolean.TYPE;
    }

    public Value(Object object) {
        this.val = object;
        this.primitiveType = null;
    }

    public Class getType() {
        if (this.primitiveType != null) {
            return this.primitiveType;
        }
        return this.val.getClass();
    }

    public boolean isPrimitive() {
        if (this.primitiveType != null) {
            return true;
        }
        return this.val.getClass() == String.class;
    }

    public String toString() {
        if (this.val == null) {
            return "null";
        }
        return this.val.toString();
    }

    public int intValue() {
        return (Integer)this.val;
    }

    public float floatValue() {
        if (this.primitiveType == Integer.TYPE) {
            return ((Integer)this.val).intValue();
        }
        return ((Float)this.val).floatValue();
    }

    public boolean booleanValue() {
        return (Boolean)this.val;
    }

    public Object objectValue() {
        return this.val;
    }

    public void set(int n) {
        this.val = new Integer(n);
        this.primitiveType = Integer.TYPE;
    }

    public void set(boolean bl) {
        this.val = new Boolean(bl);
        this.primitiveType = Boolean.TYPE;
    }

    public void set(float f) {
        this.val = new Float(f);
        this.primitiveType = Float.TYPE;
    }

    public void set(Object object) {
        this.val = object;
        this.primitiveType = null;
    }

    public void print(PrintStream printStream) {
        if (this.isPrimitive()) {
            if (this.primitiveType != Void.TYPE) {
                printStream.println(this);
            }
        } else if (this.val instanceof Value[]) {
            Value[] valueArray = (Value[])this.val;
            for (int i = 0; i < valueArray.length; ++i) {
                valueArray[i].print(printStream);
            }
        } else if (Type.isSubtypeOf(this.getType(), TupleSet.class)) {
            ((TupleSet)this.val).print(printStream);
        } else {
            printStream.println(this.val);
        }
    }

    static {
        Value.VOID.primitiveType = Void.TYPE;
        Value.EVAL.primitiveType = Void.TYPE;
    }
}

