/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.ql.interp;

import ca.uwaterloo.cs.ql.fb.EdgeSet;
import ca.uwaterloo.cs.ql.fb.NodeSet;
import ca.uwaterloo.cs.ql.fb.TupleSet;
import ca.uwaterloo.cs.ql.interp.Operation;
import ca.uwaterloo.cs.ql.interp.Operator;
import ca.uwaterloo.cs.ql.interp.op.BooleanOperation;
import ca.uwaterloo.cs.ql.interp.op.EdgeSetAnyOperation;
import ca.uwaterloo.cs.ql.interp.op.EdgeSetOperation;
import ca.uwaterloo.cs.ql.interp.op.FloatOperation;
import ca.uwaterloo.cs.ql.interp.op.IntOperation;
import ca.uwaterloo.cs.ql.interp.op.NodeSetAnyOperation;
import ca.uwaterloo.cs.ql.interp.op.NodeSetOperation;
import ca.uwaterloo.cs.ql.interp.op.StringOperation;
import ca.uwaterloo.cs.ql.interp.op.TupleSetAnyOperation;
import ca.uwaterloo.cs.ql.interp.op.TupleSetOperation;
import java.util.ArrayList;
import java.util.Hashtable;

public class TypeOperation {
    private static Hashtable allTOPs = new Hashtable();
    private int op;
    private Class type;
    private Class[] params;
    private Operation operation;

    public static TypeOperation analyze(int n, Class clazz) {
        if (clazz == null || clazz == Void.TYPE) {
            return null;
        }
        TypeOperation typeOperation = new TypeOperation(n, null, clazz);
        return typeOperation.lookup();
    }

    public static TypeOperation analyze(int n, Class clazz, Class clazz2) {
        if (clazz == null || clazz2 == null || clazz == Void.TYPE || clazz2 == Void.TYPE) {
            return null;
        }
        TypeOperation typeOperation = new TypeOperation(n, null, clazz, clazz2);
        return typeOperation.lookup();
    }

    private static void add(String string, TypeOperation typeOperation) {
        TypeOperation typeOperation2;
        ArrayList<TypeOperation> arrayList = null;
        arrayList = (ArrayList<TypeOperation>)allTOPs.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList<TypeOperation>(5);
            allTOPs.put(string, arrayList);
        }
        switch (typeOperation.params.length) {
            case 1: {
                typeOperation2 = new TypeOperation(Operator.op(string), typeOperation.type, typeOperation.params[0], typeOperation.operation);
                break;
            }
            case 2: {
                typeOperation2 = new TypeOperation(Operator.op(string), typeOperation.type, typeOperation.params[0], typeOperation.params[1], typeOperation.operation);
                break;
            }
            default: {
                typeOperation2 = typeOperation;
            }
        }
        arrayList.add(typeOperation2);
    }

    public int getOp() {
        return this.op;
    }

    public Class getType() {
        return this.type;
    }

    public Class[] getParams() {
        return this.params;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.params.length == 2) {
            stringBuffer.append(this.type.toString());
            stringBuffer.append(" = ");
            stringBuffer.append(this.params[0].toString());
            stringBuffer.append(' ');
            stringBuffer.append(Operator.key(this.op));
            stringBuffer.append(' ');
            stringBuffer.append(this.params[1].toString());
        } else {
            stringBuffer.append(this.type.toString());
            stringBuffer.append(" = ");
            stringBuffer.append(Operator.key(this.op));
            stringBuffer.append(' ');
            stringBuffer.append(this.params[0].toString());
        }
        return stringBuffer.toString();
    }

    private TypeOperation(int n, Class clazz, Class clazz2) {
        this.op = n;
        this.type = clazz;
        this.params = new Class[1];
        this.params[0] = clazz2;
    }

    private TypeOperation(int n, Class clazz, Class clazz2, Class clazz3) {
        this.op = n;
        this.type = clazz;
        this.params = new Class[2];
        this.params[0] = clazz2;
        this.params[1] = clazz3;
    }

    private TypeOperation(int n, Class clazz, Class clazz2, Operation operation) {
        this.op = n;
        this.type = clazz;
        this.params = new Class[1];
        this.params[0] = clazz2;
        this.operation = operation;
    }

    private TypeOperation(int n, Class clazz, Class clazz2, Class clazz3, Operation operation) {
        this.op = n;
        this.type = clazz;
        this.params = new Class[2];
        this.params[0] = clazz2;
        this.params[1] = clazz3;
        this.operation = operation;
    }

    private TypeOperation lookup() {
        String string = Operator.key(this.op);
        ArrayList arrayList = (ArrayList)allTOPs.get(string);
        if (arrayList == null) {
            return null;
        }
        TypeOperation typeOperation = null;
        int n = 1000;
        for (int i = 0; i < arrayList.size(); ++i) {
            TypeOperation typeOperation2 = (TypeOperation)arrayList.get(i);
            int n2 = this.distanceMatch(typeOperation2);
            if (n2 >= 0) {
                if (typeOperation == null) {
                    typeOperation = typeOperation2;
                    n = n2;
                } else if (n2 < n) {
                    typeOperation = typeOperation2;
                    n = n2;
                }
            }
            if (n2 == 0) break;
        }
        return typeOperation;
    }

    private int distanceMatch(TypeOperation typeOperation) {
        int n = 0;
        Class[] classArray = typeOperation.getParams();
        if (this.params.length != classArray.length) {
            return -1000;
        }
        if (this.params.length == 0) {
            return 0;
        }
        for (int i = 0; i < this.params.length && (n += TypeOperation.distanceTo(this.params[i], classArray[i])) >= 0; ++i) {
        }
        return n;
    }

    private static int distanceTo(Class clazz, Class clazz2) {
        if (clazz == Integer.TYPE) {
            if (clazz2 == Integer.TYPE) {
                return 0;
            }
            if (clazz2 == Float.TYPE) {
                return 1;
            }
            if (clazz2 == Object.class) {
                return 2;
            }
            return -1000;
        }
        if (clazz == Float.TYPE) {
            if (clazz2 == Float.TYPE) {
                return 0;
            }
            if (clazz2 == Object.class) {
                return 1;
            }
            return -1000;
        }
        if (clazz == Boolean.TYPE) {
            if (clazz2 == Boolean.TYPE) {
                return 0;
            }
            if (clazz2 == Object.class) {
                return 1;
            }
            return -1000;
        }
        if (clazz == String.class) {
            if (clazz2 == String.class) {
                return 0;
            }
            if (clazz2 == Object.class) {
                return 1;
            }
            return -1000;
        }
        if (clazz == EdgeSet.class) {
            if (clazz2 == EdgeSet.class) {
                return 0;
            }
            if (clazz2 == TupleSet.class) {
                return 1;
            }
            if (clazz2 == Object.class) {
                return 2;
            }
            return -1000;
        }
        if (clazz == NodeSet.class) {
            if (clazz2 == NodeSet.class) {
                return 0;
            }
            if (clazz2 == TupleSet.class) {
                return 1;
            }
            if (clazz2 == Object.class) {
                return 2;
            }
            return -1000;
        }
        if (clazz == TupleSet.class) {
            if (clazz2 == TupleSet.class) {
                return 0;
            }
            if (clazz2 == Object.class) {
                return 1;
            }
            return -1000;
        }
        return -1000;
    }

    static {
        IntOperation intOperation = new IntOperation();
        FloatOperation floatOperation = new FloatOperation();
        StringOperation stringOperation = new StringOperation();
        BooleanOperation booleanOperation = new BooleanOperation();
        NodeSetOperation nodeSetOperation = new NodeSetOperation();
        EdgeSetOperation edgeSetOperation = new EdgeSetOperation();
        TupleSetOperation tupleSetOperation = new TupleSetOperation();
        NodeSetAnyOperation nodeSetAnyOperation = new NodeSetAnyOperation();
        EdgeSetAnyOperation edgeSetAnyOperation = new EdgeSetAnyOperation();
        TupleSetAnyOperation tupleSetAnyOperation = new TupleSetAnyOperation();
        TypeOperation typeOperation = new TypeOperation(-1, Integer.TYPE, Integer.TYPE, intOperation);
        TypeOperation.add("-", typeOperation);
        TypeOperation typeOperation2 = new TypeOperation(-1, Float.TYPE, Float.TYPE, floatOperation);
        TypeOperation.add("-", typeOperation2);
        TypeOperation typeOperation3 = new TypeOperation(-1, Boolean.TYPE, Boolean.TYPE, booleanOperation);
        TypeOperation.add("!", typeOperation3);
        TypeOperation.add("!", typeOperation3);
        TypeOperation typeOperation4 = new TypeOperation(-1, Integer.TYPE, TupleSet.class, tupleSetOperation);
        TypeOperation.add("#", typeOperation4);
        TypeOperation typeOperation5 = new TypeOperation(-1, TupleSet.class, TupleSet.class, tupleSetOperation);
        TypeOperation.add("id", typeOperation5);
        TypeOperation.add("inv", typeOperation5);
        TypeOperation.add("ent", typeOperation5);
        TypeOperation.add("dom", typeOperation5);
        TypeOperation.add("rng", typeOperation5);
        TypeOperation typeOperation6 = new TypeOperation(-1, Boolean.TYPE, Object.class, TupleSet.class, tupleSetOperation);
        TypeOperation.add("in", typeOperation6);
        TypeOperation typeOperation7 = new TypeOperation(-1, Integer.TYPE, Integer.TYPE, Integer.TYPE, intOperation);
        TypeOperation typeOperation8 = new TypeOperation(-1, Boolean.TYPE, Integer.TYPE, Integer.TYPE, intOperation);
        TypeOperation.add("+", typeOperation7);
        TypeOperation.add("-", typeOperation7);
        TypeOperation.add("*", typeOperation7);
        TypeOperation.add("/", typeOperation7);
        TypeOperation.add("%", typeOperation7);
        TypeOperation.add("==", typeOperation8);
        TypeOperation.add("!=", typeOperation8);
        TypeOperation.add(">", typeOperation8);
        TypeOperation.add(">=", typeOperation8);
        TypeOperation.add("<", typeOperation8);
        TypeOperation.add("<=", typeOperation8);
        TypeOperation typeOperation9 = new TypeOperation(-1, Float.TYPE, Float.TYPE, Float.TYPE, floatOperation);
        TypeOperation typeOperation10 = new TypeOperation(-1, Boolean.TYPE, Float.TYPE, Float.TYPE, floatOperation);
        TypeOperation.add("+", typeOperation9);
        TypeOperation.add("-", typeOperation9);
        TypeOperation.add("*", typeOperation9);
        TypeOperation.add("/", typeOperation9);
        TypeOperation.add("==", typeOperation10);
        TypeOperation.add("!=", typeOperation10);
        TypeOperation.add(">", typeOperation10);
        TypeOperation.add(">=", typeOperation10);
        TypeOperation.add("<", typeOperation10);
        TypeOperation.add("<=", typeOperation10);
        TypeOperation typeOperation11 = new TypeOperation(-1, Boolean.TYPE, String.class, String.class, stringOperation);
        TypeOperation typeOperation12 = new TypeOperation(-1, String.class, String.class, Object.class, stringOperation);
        TypeOperation typeOperation13 = new TypeOperation(-1, String.class, Object.class, String.class, stringOperation);
        TypeOperation.add("==", typeOperation11);
        TypeOperation.add("!=", typeOperation11);
        TypeOperation.add("<", typeOperation11);
        TypeOperation.add("<=", typeOperation11);
        TypeOperation.add(">", typeOperation11);
        TypeOperation.add(">=", typeOperation11);
        TypeOperation.add("=~", typeOperation11);
        TypeOperation.add("!~", typeOperation11);
        TypeOperation.add("+", typeOperation12);
        TypeOperation.add("+", typeOperation13);
        TypeOperation typeOperation14 = new TypeOperation(-1, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, booleanOperation);
        TypeOperation.add("==", typeOperation14);
        TypeOperation.add("!=", typeOperation14);
        TypeOperation typeOperation15 = new TypeOperation(-1, Boolean.TYPE, NodeSet.class, NodeSet.class, nodeSetOperation);
        TypeOperation.add("==", typeOperation15);
        TypeOperation.add("!=", typeOperation15);
        TypeOperation.add("<", typeOperation15);
        TypeOperation.add("<=", typeOperation15);
        TypeOperation.add(">", typeOperation15);
        TypeOperation.add(">=", typeOperation15);
        TypeOperation typeOperation16 = new TypeOperation(-1, Boolean.TYPE, EdgeSet.class, EdgeSet.class, edgeSetOperation);
        TypeOperation.add("==", typeOperation16);
        TypeOperation.add("!=", typeOperation16);
        TypeOperation.add("<", typeOperation16);
        TypeOperation.add("<=", typeOperation16);
        TypeOperation.add(">", typeOperation16);
        TypeOperation.add(">=", typeOperation16);
        TypeOperation typeOperation17 = new TypeOperation(-1, Boolean.TYPE, TupleSet.class, TupleSet.class, tupleSetOperation);
        TypeOperation.add("==", typeOperation17);
        TypeOperation.add("!=", typeOperation17);
        TypeOperation.add("<", typeOperation17);
        TypeOperation.add("<=", typeOperation17);
        TypeOperation.add(">", typeOperation17);
        TypeOperation.add(">=", typeOperation17);
        TypeOperation typeOperation18 = new TypeOperation(-1, NodeSet.class, NodeSet.class, NodeSet.class, nodeSetOperation);
        TypeOperation.add("+", typeOperation18);
        TypeOperation.add("-", typeOperation18);
        TypeOperation.add("^", typeOperation18);
        TypeOperation.add("X", typeOperation18);
        TypeOperation typeOperation19 = new TypeOperation(-1, EdgeSet.class, EdgeSet.class, EdgeSet.class, edgeSetOperation);
        TypeOperation.add("+", typeOperation19);
        TypeOperation.add("-", typeOperation19);
        TypeOperation.add("^", typeOperation19);
        TypeOperation.add("o", typeOperation19);
        TypeOperation.add("*", typeOperation19);
        TypeOperation typeOperation20 = new TypeOperation(-1, TupleSet.class, EdgeSet.class, EdgeSet.class, edgeSetOperation);
        TypeOperation.add("**", typeOperation20);
        TypeOperation typeOperation21 = new TypeOperation(-1, EdgeSet.class, EdgeSet.class, NodeSet.class, edgeSetAnyOperation);
        TypeOperation typeOperation22 = new TypeOperation(-1, EdgeSet.class, NodeSet.class, EdgeSet.class, nodeSetAnyOperation);
        TypeOperation.add("o", typeOperation21);
        TypeOperation.add("o", typeOperation22);
        TypeOperation.add("*", typeOperation21);
        TypeOperation.add("*", typeOperation22);
        TypeOperation typeOperation23 = new TypeOperation(-1, NodeSet.class, NodeSet.class, EdgeSet.class, nodeSetAnyOperation);
        TypeOperation typeOperation24 = new TypeOperation(-1, NodeSet.class, EdgeSet.class, NodeSet.class, edgeSetAnyOperation);
        TypeOperation.add(".", typeOperation23);
        TypeOperation.add(".", typeOperation24);
        TypeOperation typeOperation25 = new TypeOperation(-1, TupleSet.class, TupleSet.class, TupleSet.class, tupleSetOperation);
        TypeOperation.add("+", typeOperation25);
        TypeOperation.add("-", typeOperation25);
        TypeOperation.add("o", typeOperation25);
        TypeOperation.add("*", typeOperation25);
        TypeOperation.add("^", typeOperation25);
        TypeOperation typeOperation26 = new TypeOperation(-1, TupleSet.class, TupleSet.class, NodeSet.class, tupleSetAnyOperation);
        TypeOperation typeOperation27 = new TypeOperation(-1, TupleSet.class, NodeSet.class, TupleSet.class, nodeSetAnyOperation);
        TypeOperation.add("o", typeOperation26);
        TypeOperation.add("o", typeOperation27);
        TypeOperation.add("*", typeOperation26);
        TypeOperation.add("*", typeOperation27);
        TypeOperation.add(".", typeOperation27);
        TypeOperation.add(".", typeOperation26);
        TypeOperation typeOperation28 = new TypeOperation(-1, TupleSet.class, TupleSet.class, EdgeSet.class, tupleSetAnyOperation);
        TypeOperation typeOperation29 = new TypeOperation(-1, TupleSet.class, EdgeSet.class, TupleSet.class, edgeSetAnyOperation);
        TypeOperation.add("o", typeOperation28);
        TypeOperation.add("o", typeOperation29);
        TypeOperation.add("*", typeOperation28);
        TypeOperation.add("*", typeOperation29);
        TypeOperation.add("**", typeOperation22);
        TypeOperation.add("**", typeOperation21);
        TypeOperation.add("**", typeOperation27);
        TypeOperation.add("**", typeOperation26);
        TypeOperation.add("**", typeOperation28);
        TypeOperation.add("**", typeOperation29);
        TypeOperation.add("**", typeOperation25);
        TypeOperation.add("**", typeOperation20);
    }
}

