/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.ql.interp;

import ca.uwaterloo.cs.ql.fb.EdgeSet;
import ca.uwaterloo.cs.ql.fb.NodeSet;
import ca.uwaterloo.cs.ql.fb.TupleSet;

public class Type {
    public static final int MATCH = 0;
    public static final int NOT_MATCH = -10000;

    public static Class findType(String string) {
        if (string == null) {
            return null;
        }
        if (string.equals("void")) {
            return Void.TYPE;
        }
        if (string.equals("int")) {
            return Integer.TYPE;
        }
        if (string.equals("float")) {
            return Float.TYPE;
        }
        if (string.equals("string")) {
            return String.class;
        }
        if (string.equals("boolean")) {
            return Boolean.TYPE;
        }
        if (string.equals("set")) {
            return NodeSet.class;
        }
        if (string.equals("eset")) {
            return EdgeSet.class;
        }
        if (string.equals("tset")) {
            return TupleSet.class;
        }
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            return null;
        }
    }

    public static String findName(Class clazz) {
        String string = clazz.getName();
        if (Type.isPrimitive(clazz)) {
            return string;
        }
        if (string.endsWith(".String")) {
            return "string";
        }
        if (string.endsWith(".NodeSet")) {
            return "set";
        }
        if (string.endsWith(".EdgeSet")) {
            return "eset";
        }
        if (string.endsWith(".TupleSet")) {
            return "tset";
        }
        int n = string.indexOf(32);
        string = string.substring(n + 1);
        return string;
    }

    public static int distanceTo(Class clazz, Class clazz2) {
        if (Type.isIdentical(clazz, clazz2)) {
            return 0;
        }
        return Type.computeDistance(clazz, clazz2);
    }

    public static int distanceTo(Class[] classArray, Class[] classArray2) {
        int n = 0;
        int n2 = classArray.length;
        int n3 = classArray2.length;
        if (n2 != n3) {
            return -10000;
        }
        if (n2 == 0) {
            return 0;
        }
        for (int i = 0; i < n2 && (n += Type.distanceTo(classArray[i], classArray2[i])) >= 0; ++i) {
        }
        return n;
    }

    private static int computeDistance(Class clazz, Class clazz2) {
        int n = 0;
        Class clazz3 = clazz.getSuperclass();
        if (clazz3 != null) {
            n = clazz2 == clazz3 ? ++n : (clazz3 == Object.class ? -10000 : 1 + Type.distanceTo(clazz3, clazz2));
        }
        if (n > 0) {
            return n;
        }
        n = 0;
        Class<?>[] classArray = clazz.getInterfaces();
        if (classArray != null) {
            for (int i = 0; i < classArray.length; ++i) {
                n = 0;
                Class<?> clazz4 = classArray[i];
                if (clazz2 == clazz4) {
                    ++n;
                } else {
                    n = 1 + Type.distanceTo(clazz4, clazz2);
                    if (n <= 0) {
                        n = -10000;
                        continue;
                    }
                }
                break;
            }
        } else {
            n = -10000;
        }
        if (n > 0) {
            return n;
        }
        return -10000;
    }

    public static boolean isPrimitive(Class clazz) {
        return clazz == Integer.TYPE || clazz == Float.TYPE || clazz == Boolean.TYPE || clazz == Void.TYPE;
    }

    public static boolean isIdentical(Class clazz, Class clazz2) {
        return clazz == clazz2;
    }

    public static boolean isSubtypeOf(Class clazz, Class clazz2) {
        return Type.distanceTo(clazz, clazz2) >= 0;
    }

    public static boolean isRelatedTo(Class clazz, Class clazz2) {
        return Type.distanceTo(clazz, clazz2) >= 0 || Type.distanceTo(clazz2, clazz) >= 0;
    }
}

