/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.ql.interp;

import ca.uwaterloo.cs.ql.fb.AlgebraOperation;
import ca.uwaterloo.cs.ql.fb.EdgeSet;
import ca.uwaterloo.cs.ql.interp.Env;
import ca.uwaterloo.cs.ql.interp.EvaluationException;
import ca.uwaterloo.cs.ql.interp.ExpressionNode;
import ca.uwaterloo.cs.ql.interp.Operator;
import ca.uwaterloo.cs.ql.interp.Value;

public class SuffixExpressionNode
extends ExpressionNode {
    int op = -100;
    ExpressionNode expNode;

    public SuffixExpressionNode(ExpressionNode expressionNode) {
        this.expNode = expressionNode;
    }

    public SuffixExpressionNode(ExpressionNode expressionNode, int n) {
        this.op = n;
        this.expNode = expressionNode;
    }

    public void propagate(Env env, Object object) throws EvaluationException {
        this.expNode.propagate(env, object);
    }

    public Value evaluate(Env env) throws EvaluationException {
        Value value = this.expNode.evaluate(env);
        if (value.getType() != EdgeSet.class) {
            throw new EvaluationException(this, "EdgeSet expected for op: " + Operator.key(this.op));
        }
        EdgeSet edgeSet = (EdgeSet)value.objectValue();
        switch (this.op) {
            case 15: {
                return new Value(AlgebraOperation.reflectiveClosure(edgeSet));
            }
            case 12: {
                return new Value(AlgebraOperation.transitiveClosure(edgeSet));
            }
            case -100: {
                return value;
            }
        }
        throw new EvaluationException(this, "illegal expression: " + value.getType() + " " + Operator.key(this.op));
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.expNode);
        stringBuffer.append(" ");
        stringBuffer.append(Operator.key(this.op));
        return stringBuffer.toString();
    }
}

