/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.ql.interp;

import ca.uwaterloo.cs.ql.interp.Env;
import ca.uwaterloo.cs.ql.interp.EvaluationException;
import ca.uwaterloo.cs.ql.interp.LookupException;
import ca.uwaterloo.cs.ql.interp.Option;
import ca.uwaterloo.cs.ql.interp.ScopedNode;
import ca.uwaterloo.cs.ql.interp.StatementNode;
import ca.uwaterloo.cs.ql.interp.Value;
import ca.uwaterloo.cs.ql.interp.Variable;
import ca.uwaterloo.cs.ql.util.Timing;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class ScriptUnitNode
extends ScopedNode {
    private int currStmtNum = 0;
    private File scriptFile = null;
    private String aliasName = null;
    private Option unitOption = new Option();
    private Hashtable sourceUnits = new Hashtable(5);
    private ArrayList stmtNodeList = new ArrayList(20);
    private StringBuffer echoIndent = new StringBuffer();

    public ScriptUnitNode() {
        super(null);
    }

    public File getFile() {
        return this.scriptFile;
    }

    public void setFile(File file) {
        if (file != null) {
            try {
                this.scriptFile = file.getCanonicalFile();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                this.scriptFile = null;
            }
        } else {
            this.scriptFile = null;
        }
    }

    public String getAliasName() {
        return this.aliasName;
    }

    public void setAliasName(String string) {
        this.aliasName = string;
    }

    public String getFileName() {
        if (this.scriptFile != null) {
            return this.scriptFile.getName();
        }
        return null;
    }

    public String getFullName() {
        return this.getFilePath();
    }

    public String getFilePath() {
        if (this.scriptFile != null) {
            return this.scriptFile.getPath();
        }
        return null;
    }

    public String getFileParent() {
        if (this.scriptFile != null) {
            return this.scriptFile.getParent();
        }
        return System.getProperty("user.dir");
    }

    public Option getOption() {
        return this.unitOption;
    }

    public void setOption(Option option) {
        if (option != null) {
            this.unitOption = option;
        }
    }

    public boolean isEchoOn() {
        return this.unitOption.isEchoOn();
    }

    public boolean isTimeOn() {
        return this.unitOption.isTimeOn();
    }

    public boolean isPauseOn() {
        return this.unitOption.isPauseOn();
    }

    public void addStatement(StatementNode statementNode) {
        if (statementNode != null) {
            this.stmtNodeList.add(statementNode);
        }
    }

    public ScriptUnitNode[] getSourceUnits() {
        ArrayList arrayList = new ArrayList(8);
        Enumeration enumeration = this.sourceUnits.elements();
        while (enumeration.hasMoreElements()) {
            Object v = enumeration.nextElement();
            if (v instanceof ScriptUnitNode) {
                arrayList.add(v);
                continue;
            }
            arrayList.addAll(((UnitContainer)v).list);
        }
        ScriptUnitNode[] scriptUnitNodeArray = new ScriptUnitNode[arrayList.size()];
        arrayList.toArray(scriptUnitNodeArray);
        return scriptUnitNodeArray;
    }

    public ScriptUnitNode[] getSourceUnits(String string) {
        ScriptUnitNode[] scriptUnitNodeArray;
        if (string == null) {
            return new ScriptUnitNode[0];
        }
        Object v = this.sourceUnits.get(string);
        if (v == null) {
            scriptUnitNodeArray = new ScriptUnitNode[]{};
        } else if (v instanceof ScriptUnitNode) {
            scriptUnitNodeArray = new ScriptUnitNode[]{(ScriptUnitNode)v};
        } else {
            UnitContainer unitContainer = (UnitContainer)v;
            scriptUnitNodeArray = new ScriptUnitNode[unitContainer.list.size()];
            unitContainer.list.toArray(scriptUnitNodeArray);
        }
        return scriptUnitNodeArray;
    }

    public void addSourceUnit(ScriptUnitNode scriptUnitNode) {
        if (scriptUnitNode == null) {
            return;
        }
        String string = scriptUnitNode.getAliasName();
        if (!this.sourceUnits.containsKey(string)) {
            this.sourceUnits.put(string, scriptUnitNode);
        } else {
            Object v = this.sourceUnits.get(string);
            if (v instanceof ScriptUnitNode) {
                ScriptUnitNode scriptUnitNode2 = (ScriptUnitNode)v;
                if (scriptUnitNode2.getFilePath().equals(scriptUnitNode.getFilePath())) {
                    Enumeration enumeration = scriptUnitNode2.allVariables();
                    while (enumeration.hasMoreElements()) {
                        Variable variable = (Variable)enumeration.nextElement();
                        variable.setValue(null);
                    }
                    this.sourceUnits.put(string, scriptUnitNode);
                } else {
                    UnitContainer unitContainer = new UnitContainer(scriptUnitNode2);
                    unitContainer.add(scriptUnitNode);
                    this.sourceUnits.put(string, unitContainer);
                }
            } else {
                int n;
                ArrayList arrayList = ((UnitContainer)v).list;
                for (n = 0; n < arrayList.size(); ++n) {
                    ScriptUnitNode scriptUnitNode3 = (ScriptUnitNode)arrayList.get(n);
                    if (!scriptUnitNode3.getFilePath().equals(scriptUnitNode.getFilePath())) continue;
                    Enumeration enumeration = scriptUnitNode3.allVariables();
                    while (enumeration.hasMoreElements()) {
                        Variable variable = (Variable)enumeration.nextElement();
                        variable.setValue(null);
                    }
                    arrayList.set(n, scriptUnitNode);
                    break;
                }
                if (n == arrayList.size()) {
                    arrayList.add(scriptUnitNode);
                }
            }
        }
    }

    public Variable lookup(String string) throws LookupException {
        Variable variable = (Variable)this.varTbl.get(string);
        if (variable == null) {
            throw new LookupException(string);
        }
        return variable;
    }

    public void propagate(Env env, Object object) throws EvaluationException {
    }

    public Value evaluate(Env env) throws EvaluationException {
        Timing timing2 = new Timing();
        int n = this.stmtNodeList.size();
        for (int i = 0; i < n; ++i) {
            StatementNode statementNode = (StatementNode)this.stmtNodeList.get(i);
            if (this.isEchoOn()) {
                env.out.print("echo:");
                env.out.println(statementNode.toString());
            }
            if (this.isTimeOn()) {
                timing2.start();
            }
            Value value = statementNode.evaluate(env);
            if (this.isTimeOn()) {
                timing2.stop();
                env.out.print("time:\t");
                env.out.println(statementNode.shortFormLocation() + " " + timing2.getTime());
            }
            if (value == Value.EVAL) continue;
            return value;
        }
        return Value.EVAL;
    }

    public Value debugEvaluate(Env env, int n) throws EvaluationException {
        Timing timing2 = new Timing();
        int n2 = this.stmtNodeList.size();
        if (this.currStmtNum >= n2) {
            env.out.println("[qdb]: no more scripts left");
            return Value.EVAL;
        }
        if (n == 2) {
            StatementNode statementNode = (StatementNode)this.stmtNodeList.get(this.currStmtNum);
            env.out.println(statementNode.shortFormLocation());
            env.out.println(statementNode.toString());
            return Value.EVAL;
        }
        if (n == 1) {
            this.getOption().setPauseOn(false);
        }
        boolean bl = false;
        while (this.currStmtNum < n2 && !bl) {
            StatementNode statementNode = (StatementNode)this.stmtNodeList.get(this.currStmtNum);
            if (this.isEchoOn()) {
                env.out.print("echo:");
                env.out.println(statementNode.toString());
            }
            if (this.isTimeOn()) {
                timing2.start();
            }
            Value value = statementNode.evaluate(env);
            if (this.isTimeOn()) {
                timing2.stop();
                env.out.print("time:\t");
                env.out.println(statementNode.shortFormLocation() + " " + timing2.getTime());
            }
            switch (n) {
                case 1: {
                    if (!this.isPauseOn()) break;
                    bl = true;
                    break;
                }
                case 3: {
                    bl = true;
                    break;
                }
                default: {
                    bl = false;
                }
            }
            if (value != Value.EVAL) {
                this.currStmtNum = n2;
                return value;
            }
            ++this.currStmtNum;
        }
        return Value.EVAL;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.stmtNodeList.size(); ++i) {
            stringBuffer.append(this.stmtNodeList.get(i));
            stringBuffer.append("\n\n");
        }
        return stringBuffer.toString();
    }

    public void incrEchoIndent() {
        this.echoIndent.append("\t");
    }

    public void decrEchoIndent() {
        int n = this.echoIndent.length();
        if (n > 0) {
            this.echoIndent.delete(n - 1, n);
        }
    }

    public String getEchoIndent() {
        return this.echoIndent.toString();
    }

    private class UnitContainer {
        ArrayList list = new ArrayList(4);

        UnitContainer(ScriptUnitNode scriptUnitNode2) {
            this.list.add(scriptUnitNode2);
        }

        void add(ScriptUnitNode scriptUnitNode) {
            this.list.add(scriptUnitNode);
        }
    }
}

