/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.ql.interp;

import ca.uwaterloo.cs.ql.interp.LookupException;
import ca.uwaterloo.cs.ql.interp.Scope;
import ca.uwaterloo.cs.ql.interp.SyntaxTreeNode;
import ca.uwaterloo.cs.ql.interp.Variable;
import java.util.Enumeration;
import java.util.Hashtable;

public abstract class ScopedNode
extends SyntaxTreeNode
implements Scope {
    protected Scope parent;
    protected Hashtable varTbl;

    public ScopedNode(Scope scope) {
        this.parent = scope;
        this.varTbl = new Hashtable();
    }

    public void clear() {
        this.varTbl.clear();
    }

    public Scope getParent() {
        return this.parent;
    }

    public Enumeration allVariables() {
        return this.varTbl.elements();
    }

    public void addVariable(Variable variable) {
        if (variable != null) {
            this.varTbl.put(variable.getName(), variable);
        }
    }

    public void removeVariable(Variable variable) {
        if (variable != null) {
            this.varTbl.remove(variable.getName());
        }
    }

    public boolean hasVariable(String string) {
        return this.varTbl.containsKey(string);
    }

    public abstract Variable lookup(String var1) throws LookupException;
}

