/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.ql.interp;

import ca.uwaterloo.cs.ql.interp.Env;
import ca.uwaterloo.cs.ql.interp.EvaluationException;
import ca.uwaterloo.cs.ql.interp.ExpressionNode;
import ca.uwaterloo.cs.ql.interp.StatementNode;
import ca.uwaterloo.cs.ql.interp.Value;
import ca.uwaterloo.cs.ql.io.FileOutputAppendStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public class RedirectStatementNode
extends StatementNode {
    StatementNode stmtNode;
    ExpressionNode expNode;
    boolean isAppend;

    public RedirectStatementNode(StatementNode statementNode, ExpressionNode expressionNode, boolean bl) {
        this.stmtNode = statementNode;
        this.expNode = expressionNode;
        this.isAppend = bl;
    }

    public Value evaluate(Env env) throws EvaluationException {
        Value value = this.expNode.evaluate(env);
        if (value.getType() != String.class) {
            throw new EvaluationException(this.expNode, "string expected after >>");
        }
        String string = value.toString();
        PrintStream printStream = env.out;
        try {
            string = value.toString();
            env.out = this.isAppend ? new PrintStream(new FileOutputAppendStream(string), true) : new PrintStream(new FileOutputStream(string), true);
            this.stmtNode.evaluate(env);
            env.out.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new EvaluationException(this.expNode, string + " not found");
        }
        catch (IOException iOException) {
            throw new EvaluationException(this.expNode, iOException.getMessage());
        }
        finally {
            env.out = printStream;
        }
        return Value.EVAL;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getIndent());
        stringBuffer.append(this.stmtNode);
        stringBuffer.append(' ');
        stringBuffer.append(">>");
        if (this.isAppend) {
            stringBuffer.append('>');
        }
        stringBuffer.append(' ');
        stringBuffer.append(this.expNode);
        return stringBuffer.toString();
    }
}

