/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.ql.interp;

import ca.uwaterloo.cs.ql.fb.Column;
import ca.uwaterloo.cs.ql.fb.Header;
import ca.uwaterloo.cs.ql.fb.Relation;
import ca.uwaterloo.cs.ql.fb.TupleSet;
import ca.uwaterloo.cs.ql.interp.Env;
import ca.uwaterloo.cs.ql.interp.EvaluationException;
import ca.uwaterloo.cs.ql.interp.StatementNode;
import ca.uwaterloo.cs.ql.interp.Value;
import ca.uwaterloo.cs.ql.interp.VariableNode;
import java.util.ArrayList;

public class PrologExpressionNode
extends StatementNode {
    VariableNode varNode;
    ArrayList argVarNodes;

    public PrologExpressionNode(VariableNode variableNode, ArrayList arrayList) {
        this.varNode = variableNode;
        this.argVarNodes = arrayList;
    }

    public Value evaluate(Env env) throws EvaluationException {
        Value value = this.varNode.evaluate(env);
        if (value.objectValue() instanceof TupleSet) {
            Relation relation = new Relation(this.getHeader(), (TupleSet)value.objectValue(), true);
            return new Value(relation);
        }
        throw new EvaluationException(this.varNode, "unknown prolog error //???");
    }

    Header getHeader() {
        int n = this.argVarNodes.size();
        Column[] columnArray = new Column[n];
        for (int i = 0; i < n; ++i) {
            columnArray[i] = new Column(((VariableNode)this.argVarNodes.get(i)).toString());
        }
        return new Header(columnArray);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.varNode);
        stringBuffer.append('(');
        for (int i = 0; i < this.argVarNodes.size(); ++i) {
            if (i > 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append((VariableNode)this.argVarNodes.get(i));
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }
}

