/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.ql.interp;

import ca.uwaterloo.cs.ql.fb.Header;
import ca.uwaterloo.cs.ql.fb.Relation;
import ca.uwaterloo.cs.ql.fb.UnknownColumnException;
import ca.uwaterloo.cs.ql.interp.BlockStatementNode;
import ca.uwaterloo.cs.ql.interp.Env;
import ca.uwaterloo.cs.ql.interp.EvaluationException;
import ca.uwaterloo.cs.ql.interp.LookupException;
import ca.uwaterloo.cs.ql.interp.PrologExpressionNode;
import ca.uwaterloo.cs.ql.interp.Scope;
import ca.uwaterloo.cs.ql.interp.StatementNode;
import ca.uwaterloo.cs.ql.interp.Value;
import ca.uwaterloo.cs.ql.interp.Variable;
import java.util.ArrayList;

public class PrologClauseNode
extends StatementNode {
    PrologExpressionNode expNode;
    StatementNode bodyNode;

    public PrologClauseNode(PrologExpressionNode prologExpressionNode, StatementNode statementNode) {
        this.expNode = prologExpressionNode;
        this.bodyNode = statementNode;
    }

    public Value evaluate(Env env) throws EvaluationException {
        Header header = this.expNode.getHeader();
        if (this.bodyNode instanceof BlockStatementNode) {
            Variable variable;
            Object object;
            ArrayList arrayList = ((BlockStatementNode)this.bodyNode).stmtNodes;
            ArrayList arrayList2 = (ArrayList)arrayList.clone();
            ArrayList<Object> arrayList3 = new ArrayList<Object>();
            for (int i = 0; i < arrayList.size(); ++i) {
                StatementNode statementNode = (StatementNode)arrayList.get(i);
                if (!(statementNode instanceof PrologExpressionNode)) continue;
                object = statementNode.evaluate(env);
                arrayList3.add(((Value)object).objectValue());
                arrayList2.remove(statementNode);
            }
            this.compose(arrayList3);
            Relation relation = (Relation)arrayList3.get(0);
            try {
                relation = Relation.project(relation, header);
            }
            catch (UnknownColumnException unknownColumnException) {
                throw new EvaluationException(this.expNode, unknownColumnException.getMessage());
            }
            object = env.peepScope();
            String string = this.expNode.varNode.toString();
            try {
                variable = object.lookup(string);
            }
            catch (LookupException lookupException) {
                variable = new Variable((Scope)object, string);
                object.addVariable(variable);
            }
            variable.setValue(new Value(relation.getBody()));
            return Value.EVAL;
        }
        return this.bodyNode.evaluate(env);
    }

    private void compose(ArrayList arrayList) {
        boolean bl = true;
        block0: while (bl) {
            bl = false;
            for (int i = 0; i < arrayList.size(); ++i) {
                Relation relation = (Relation)arrayList.get(i);
                Header header = relation.getHeader();
                for (int j = i + 1; j < arrayList.size(); ++j) {
                    Relation relation2 = (Relation)arrayList.get(j);
                    Header header2 = relation2.getHeader();
                    Header header3 = header.intersect(header2);
                    if (header3.size() <= 0) continue;
                    Relation relation3 = Relation.compose(relation, relation2, header3);
                    arrayList.remove(j);
                    arrayList.remove(i);
                    arrayList.add(relation3);
                    bl = true;
                    break;
                }
                if (bl) continue block0;
            }
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getIndent());
        stringBuffer.append(this.expNode);
        stringBuffer.append(" = ");
        stringBuffer.append(this.bodyNode);
        return stringBuffer.toString();
    }
}

