/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.ql.interp;

import ca.uwaterloo.cs.ql.interp.Env;
import ca.uwaterloo.cs.ql.interp.ErrorMessage;
import ca.uwaterloo.cs.ql.interp.EvaluationException;
import ca.uwaterloo.cs.ql.interp.ExpressionNode;
import ca.uwaterloo.cs.ql.interp.Operation;
import ca.uwaterloo.cs.ql.interp.Operator;
import ca.uwaterloo.cs.ql.interp.TypeOperation;
import ca.uwaterloo.cs.ql.interp.Value;

public class PrefixExpressionNode
extends ExpressionNode {
    int op;
    ExpressionNode expNode;

    public PrefixExpressionNode(int n, ExpressionNode expressionNode) {
        this.op = n;
        this.expNode = expressionNode;
    }

    public void propagate(Env env, Object object) throws EvaluationException {
        this.expNode.propagate(env, object);
    }

    public Value evaluate(Env env) throws EvaluationException {
        Value value = this.expNode.evaluate(env);
        TypeOperation typeOperation = TypeOperation.analyze(this.op, value.getType());
        if (typeOperation != null) {
            try {
                Operation operation = typeOperation.getOperation();
                return operation.eval(this.op, value);
            }
            catch (Exception exception) {
                throw new EvaluationException(this, exception.getMessage());
            }
        }
        String string = ErrorMessage.errUnsupportedOperation(this.op, value.getType());
        throw new EvaluationException(this, string);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Operator.key(this.op));
        stringBuffer.append(" ");
        stringBuffer.append(this.expNode);
        return stringBuffer.toString();
    }
}

