/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.ql.interp;

import ca.uwaterloo.cs.ql.interp.Env;
import ca.uwaterloo.cs.ql.interp.EvaluationException;
import ca.uwaterloo.cs.ql.interp.ExpressionNode;
import ca.uwaterloo.cs.ql.interp.StatementNode;
import ca.uwaterloo.cs.ql.interp.Value;

public class IfStatementNode
extends StatementNode {
    ExpressionNode expNode;
    StatementNode thenNode;
    StatementNode elseNode;

    public IfStatementNode(ExpressionNode expressionNode, StatementNode statementNode) {
        this(expressionNode, statementNode, null);
    }

    public IfStatementNode(ExpressionNode expressionNode, StatementNode statementNode, StatementNode statementNode2) {
        this.expNode = expressionNode;
        this.thenNode = statementNode;
        this.elseNode = statementNode2;
    }

    public Value evaluate(Env env) throws EvaluationException {
        Value value = this.expNode.evaluate(env);
        if (value.getType() != Boolean.TYPE) {
            throw new EvaluationException(this.expNode, "not evaluated to boolean");
        }
        if (value.booleanValue()) {
            return this.thenNode.evaluate(env);
        }
        if (this.elseNode != null) {
            return this.elseNode.evaluate(env);
        }
        return Value.EVAL;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getIndent());
        stringBuffer.append("if ");
        stringBuffer.append(this.expNode);
        stringBuffer.append(" \n");
        stringBuffer.append(this.thenNode);
        if (this.elseNode != null) {
            stringBuffer.append("\n");
            stringBuffer.append(this.getIndent());
            stringBuffer.append("else \n");
            stringBuffer.append(this.elseNode);
        }
        return stringBuffer.toString();
    }
}

