/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.ql.interp;

import ca.uwaterloo.cs.ql.interp.ArgumentsNode;
import ca.uwaterloo.cs.ql.interp.Env;
import ca.uwaterloo.cs.ql.interp.EvaluationException;
import ca.uwaterloo.cs.ql.interp.ExpressionNode;
import ca.uwaterloo.cs.ql.interp.FunctionNameNode;
import ca.uwaterloo.cs.ql.interp.LookupException;
import ca.uwaterloo.cs.ql.interp.Value;
import ca.uwaterloo.cs.ql.lib.Function;
import ca.uwaterloo.cs.ql.lib.InvocationException;

public class FunctionExpressionNode
extends ExpressionNode {
    FunctionNameNode nameNode;
    ArgumentsNode argsNode;
    Function function;

    public FunctionExpressionNode(FunctionNameNode functionNameNode, ArgumentsNode argumentsNode) {
        this.nameNode = functionNameNode;
        this.argsNode = argumentsNode;
    }

    public void propagate(Env env, Object object) throws EvaluationException {
        this.nameNode.propagate(env, object);
        this.argsNode.propagate(env, object);
    }

    public Value evaluate(Env env) throws EvaluationException {
        Value value = this.argsNode.evaluate(env);
        Object object = value.objectValue();
        Value[] valueArray = object instanceof Value[] ? (Value[])object : new Value[]{value};
        Class[] classArray = new Class[valueArray.length];
        for (int i = 0; i < valueArray.length; ++i) {
            classArray[i] = valueArray[i].getType();
        }
        try {
            String string = this.nameNode.evalName(env);
            this.function = env.lookupFunction(string, classArray);
        }
        catch (LookupException lookupException) {
            throw new EvaluationException(this, lookupException.getMessage());
        }
        try {
            return this.function.invoke(env, valueArray);
        }
        catch (InvocationException invocationException) {
            throw new EvaluationException(this, invocationException.getMessage());
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.nameNode);
        stringBuffer.append(this.argsNode);
        return stringBuffer.toString();
    }
}

