/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.ql.interp;

import ca.uwaterloo.cs.ql.fb.Node;
import ca.uwaterloo.cs.ql.fb.NodeSet;
import ca.uwaterloo.cs.ql.interp.Env;
import ca.uwaterloo.cs.ql.interp.EvaluationException;
import ca.uwaterloo.cs.ql.interp.ExpressionNode;
import ca.uwaterloo.cs.ql.interp.LookupException;
import ca.uwaterloo.cs.ql.interp.Scope;
import ca.uwaterloo.cs.ql.interp.StatementNode;
import ca.uwaterloo.cs.ql.interp.Value;
import ca.uwaterloo.cs.ql.interp.Variable;
import ca.uwaterloo.cs.ql.interp.VariableNode;

public class ForStatementNode
extends StatementNode {
    VariableNode varNode;
    ExpressionNode expNode;
    StatementNode bodyNode;

    public ForStatementNode(VariableNode variableNode, ExpressionNode expressionNode, StatementNode statementNode) {
        this.varNode = variableNode;
        this.expNode = expressionNode;
        this.bodyNode = statementNode;
    }

    public Value evaluate(Env env) throws EvaluationException {
        Object object;
        Variable variable;
        try {
            variable = env.peepScope().lookup(this.varNode.getName());
        }
        catch (LookupException lookupException) {
            object = env.peepScope();
            variable = new Variable((Scope)object, this.varNode.getName());
            object.addVariable(variable);
        }
        object = this.expNode.evaluate(env);
        Class clazz = ((Value)object).getType();
        if (clazz == NodeSet.class) {
            NodeSet nodeSet = (NodeSet)((Value)object).objectValue();
            Node[] nodeArray = nodeSet.getAllNodes();
            for (int i = 0; i < nodeArray.length; ++i) {
                variable.setValue(new Value(nodeArray[i].get()));
                Value value = this.bodyNode.evaluate(env);
                if (value == Value.EVAL) continue;
                return value;
            }
        } else {
            throw new EvaluationException(this.expNode, "illegal set expression");
        }
        return Value.EVAL;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getIndent());
        stringBuffer.append("for ");
        stringBuffer.append(this.varNode);
        stringBuffer.append(" in ");
        stringBuffer.append(this.expNode);
        stringBuffer.append("\n");
        stringBuffer.append(this.bodyNode);
        return stringBuffer.toString();
    }
}

