/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.ql.interp;

import ca.uwaterloo.cs.ql.interp.LookupException;
import ca.uwaterloo.cs.ql.interp.Scope;
import ca.uwaterloo.cs.ql.interp.ScriptUnitNode;
import ca.uwaterloo.cs.ql.interp.Variable;
import ca.uwaterloo.cs.ql.lib.Function;
import ca.uwaterloo.cs.ql.lib.FunctionLib;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;

public class Env {
    public InputStream in = System.in;
    public PrintStream out = System.out;
    public PrintStream err = System.err;
    private ArrayList scopes = new ArrayList(10);
    private ScriptUnitNode mainUnit;
    private FunctionLib functionLib = FunctionLib.instance();

    public ScriptUnitNode getMainUnit() {
        return this.mainUnit;
    }

    public void setMainUnit(ScriptUnitNode scriptUnitNode) {
        this.mainUnit = scriptUnitNode;
    }

    public void removeAllScopes() {
        this.scopes.clear();
    }

    public Scope popScope() {
        return (Scope)this.scopes.remove(this.scopes.size() - 1);
    }

    public void pushScope(Scope scope) {
        this.scopes.add(scope);
    }

    public Scope peepScope() {
        return (Scope)this.scopes.get(this.scopes.size() - 1);
    }

    public ScriptUnitNode traceScriptUnit() {
        Scope scope = this.peepScope();
        if (scope instanceof ScriptUnitNode) {
            return (ScriptUnitNode)scope;
        }
        while (scope != null) {
            if (!((scope = scope.getParent()) instanceof ScriptUnitNode)) continue;
            return (ScriptUnitNode)scope;
        }
        return null;
    }

    public Variable lookup(String string) throws LookupException {
        Variable variable = null;
        LookupException lookupException = null;
        for (int i = this.scopes.size() - 1; i >= 0; --i) {
            Scope scope = (Scope)this.scopes.get(i);
            try {
                variable = scope.lookup(string);
                return variable;
            }
            catch (LookupException lookupException2) {
                if (lookupException != null) continue;
                lookupException = lookupException2;
                continue;
            }
        }
        if (lookupException != null) {
            throw lookupException;
        }
        return variable;
    }

    public Function lookupFunction(String string, Class[] classArray) throws LookupException {
        Function function = this.functionLib.find(string, classArray);
        if (function != null) {
            return function;
        }
        throw new LookupException("function " + string);
    }

    public Function[] lookupFunctions(String string) throws LookupException {
        Function[] functionArray = this.functionLib.find(string);
        if (functionArray.length != 0) {
            return functionArray;
        }
        throw new LookupException("function " + string);
    }
}

