/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.ql.interp;

import ca.uwaterloo.cs.ql.interp.Env;
import ca.uwaterloo.cs.ql.interp.ErrorMessage;
import ca.uwaterloo.cs.ql.interp.EvalName;
import ca.uwaterloo.cs.ql.interp.EvaluationException;
import ca.uwaterloo.cs.ql.interp.LookupException;
import ca.uwaterloo.cs.ql.interp.Value;
import ca.uwaterloo.cs.ql.interp.Variable;
import ca.uwaterloo.cs.ql.interp.VariableNode;

public class DollarSignNode
extends VariableNode
implements EvalName {
    public DollarSignNode(String string) {
        super(string);
    }

    public String getName() {
        return this.name;
    }

    public Value evaluate(Env env) throws EvaluationException {
        try {
            Variable variable = env.lookup(this.evalName(env));
            if (variable.getValue() == null) {
                throw new EvaluationException(this, ErrorMessage.errUnresolvable(this.evalName(env)));
            }
            return variable.getValue();
        }
        catch (LookupException lookupException) {
            throw new EvaluationException(this, lookupException.getMessage());
        }
    }

    public String evalName(Env env) throws EvaluationException {
        try {
            Variable variable = env.lookup(this.toString());
            if (variable.getValue() == null) {
                throw new EvaluationException(this, ErrorMessage.errUnresolvable(this.toString()));
            }
            return variable.getName();
        }
        catch (LookupException lookupException) {
            try {
                Variable variable = env.lookup(this.name);
                Value value = variable.getValue();
                if (value == null) {
                    throw new EvaluationException(this, ErrorMessage.errUnresolvable(this.name));
                }
                if (value.getType() != String.class) {
                    throw new EvaluationException(this, "String expected after $");
                }
                return value.toString();
            }
            catch (LookupException lookupException2) {
                throw new EvaluationException(this, lookupException.getMessage());
            }
        }
    }

    public String toString() {
        return "$" + this.name;
    }
}

