/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.ql.interp;

import ca.uwaterloo.cs.ql.interp.Env;
import ca.uwaterloo.cs.ql.interp.EvaluationException;
import ca.uwaterloo.cs.ql.interp.ExpressionNode;
import ca.uwaterloo.cs.ql.interp.Value;

public class ConditionalOrExpressionNode
extends ExpressionNode {
    ExpressionNode left;
    ExpressionNode right;

    public ConditionalOrExpressionNode(ExpressionNode expressionNode, ExpressionNode expressionNode2) {
        this.left = expressionNode;
        this.right = expressionNode2;
    }

    public void propagate(Env env, Object object) throws EvaluationException {
        this.left.propagate(env, object);
        this.right.propagate(env, object);
    }

    public Value evaluate(Env env) throws EvaluationException {
        Value value = this.left.evaluate(env);
        Value value2 = this.right.evaluate(env);
        Class clazz = value.getType();
        if (clazz != Boolean.TYPE) {
            throw new EvaluationException(this.left, "boolean expression expected");
        }
        clazz = value2.getType();
        if (clazz != Boolean.TYPE) {
            throw new EvaluationException(this.right, "boolean expression expected");
        }
        return new Value(value.booleanValue() || value2.booleanValue());
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.left);
        stringBuffer.append(" || ");
        stringBuffer.append(this.right);
        return stringBuffer.toString();
    }
}

