/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.ql.interp;

import ca.uwaterloo.cs.ql.interp.ArgumentsNode;
import ca.uwaterloo.cs.ql.interp.CommandNode;
import ca.uwaterloo.cs.ql.interp.Env;
import ca.uwaterloo.cs.ql.interp.EvalName;
import ca.uwaterloo.cs.ql.interp.EvaluationException;
import ca.uwaterloo.cs.ql.interp.ExpressionNode;
import ca.uwaterloo.cs.ql.interp.LookupException;
import ca.uwaterloo.cs.ql.interp.Scope;
import ca.uwaterloo.cs.ql.interp.Value;
import ca.uwaterloo.cs.ql.interp.Variable;

public class CommandDeleteNode
extends CommandNode {
    ExpressionNode expNode;

    public CommandDeleteNode(ExpressionNode expressionNode) {
        super("delete");
        this.expNode = expressionNode;
    }

    public Value evaluate(Env env) throws EvaluationException {
        Scope scope = env.peepScope();
        if (this.expNode instanceof ArgumentsNode) {
            ArgumentsNode argumentsNode = (ArgumentsNode)this.expNode;
            ExpressionNode[] expressionNodeArray = argumentsNode.getArguments();
            for (int i = 0; i < expressionNodeArray.length; ++i) {
                Variable variable;
                String string;
                ExpressionNode expressionNode = expressionNodeArray[i];
                if (expressionNode instanceof EvalName) {
                    string = ((EvalName)((Object)expressionNode)).evalName(env);
                } else {
                    Value value = expressionNode.evaluate(env);
                    if (value.getType() == String.class) {
                        string = value.toString();
                    } else {
                        throw new EvaluationException(expressionNode, "illegal expression: " + expressionNode);
                    }
                }
                try {
                    variable = scope.lookup(string);
                }
                catch (LookupException lookupException) {
                    continue;
                }
                scope.removeVariable(variable);
            }
        } else {
            Variable variable;
            String string;
            if (this.expNode instanceof EvalName) {
                string = ((EvalName)((Object)this.expNode)).evalName(env);
            } else {
                Value value = this.expNode.evaluate(env);
                if (value.getType() == String.class) {
                    string = value.toString();
                } else {
                    throw new EvaluationException(this.expNode, "illegal expression: " + this.expNode);
                }
            }
            try {
                variable = scope.lookup(string);
            }
            catch (LookupException lookupException) {
                return Value.EVAL;
            }
            scope.removeVariable(variable);
        }
        return Value.EVAL;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getIndent());
        stringBuffer.append("delete");
        if (!(this.expNode instanceof ArgumentsNode)) {
            stringBuffer.append(' ');
        }
        stringBuffer.append(this.expNode);
        return stringBuffer.toString();
    }
}

