/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.ql.interp;

import ca.uwaterloo.cs.ql.fb.TupleSet;
import ca.uwaterloo.cs.ql.interp.Env;
import ca.uwaterloo.cs.ql.interp.EvaluationException;
import ca.uwaterloo.cs.ql.interp.ExpressionNode;
import ca.uwaterloo.cs.ql.interp.LookupException;
import ca.uwaterloo.cs.ql.interp.Scope;
import ca.uwaterloo.cs.ql.interp.StatementNode;
import ca.uwaterloo.cs.ql.interp.Value;
import ca.uwaterloo.cs.ql.interp.Variable;
import ca.uwaterloo.cs.ql.interp.VariableNode;

public class AssignmentNode
extends StatementNode {
    VariableNode[] lefts;
    ExpressionNode expNode;

    public AssignmentNode(VariableNode variableNode, ExpressionNode expressionNode) {
        this.lefts = new VariableNode[1];
        this.lefts[0] = variableNode;
        this.expNode = expressionNode;
    }

    public AssignmentNode(VariableNode[] variableNodeArray, ExpressionNode expressionNode) {
        this.lefts = variableNodeArray;
        this.expNode = expressionNode;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Value evaluate(Env env) throws EvaluationException {
        int n;
        Object object;
        Object object2;
        Scope scope = env.peepScope();
        Variable[] variableArray = new Variable[this.lefts.length];
        for (int i = 0; i < this.lefts.length; ++i) {
            Variable variable;
            String string;
            VariableNode variableNode = this.lefts[i];
            try {
                string = variableNode.evalName(env);
            }
            catch (EvaluationException evaluationException) {
                string = variableNode.toString();
            }
            try {
                variable = scope.lookup(string);
            }
            catch (LookupException lookupException) {
                variable = new Variable(scope, string);
                scope.addVariable(variable);
            }
            variableArray[i] = variable;
        }
        try {
            object2 = this.expNode.evaluate(env);
        }
        catch (EvaluationException evaluationException) {
            for (int i = 0; i < variableArray.length; ++i) {
                if (variableArray[i].getValue() != null) continue;
                scope.removeVariable(variableArray[i]);
            }
            throw evaluationException;
        }
        Object object3 = ((Value)object2).objectValue();
        if (!(object3 instanceof Value[])) {
            if (this.lefts.length == 1) {
                if (object3 instanceof TupleSet) {
                    object = (TupleSet)object3;
                    if (((TupleSet)object).hasName()) {
                        object2 = new Value(((TupleSet)object).clone());
                        object = (TupleSet)((Value)object2).objectValue();
                    }
                    ((TupleSet)object).setName(variableArray[0].getName());
                    ((TupleSet)object).removeDuplicates();
                }
            } else {
                for (int i = 1; i < variableArray.length; ++i) {
                    if (variableArray[i].getValue() != null) continue;
                    scope.removeVariable(variableArray[i]);
                }
                if (variableArray.length > 1) {
                    throw new EvaluationException(this.lefts[1], variableArray[1].getName() + " not assigned a value");
                }
            }
            variableArray[0].setValue((Value)object2);
            return Value.EVAL;
        }
        object = (Value[])object3;
        if (this.lefts.length == 1) {
            if (((Value[])object).length < 1) throw new EvaluationException(this.lefts[0], variableArray[0].getName() + " not assigned a value");
            object2 = object[0];
            object3 = ((Value)object2).objectValue();
            if (object3 instanceof TupleSet) {
                TupleSet tupleSet = (TupleSet)object3;
                if (tupleSet.hasName()) {
                    object2 = new Value(tupleSet.clone());
                    tupleSet = (TupleSet)((Value)object2).objectValue();
                }
                tupleSet.setName(variableArray[0].getName());
                tupleSet.removeDuplicates();
            }
            variableArray[0].setValue((Value)object2);
            return Value.EVAL;
        }
        try {
            for (n = 0; n < this.lefts.length; ++n) {
                object2 = object[n];
                Object object4 = ((Value)object2).objectValue();
                if (object4 instanceof TupleSet) {
                    TupleSet tupleSet = (TupleSet)object4;
                    if (tupleSet.hasName()) {
                        object2 = new Value(tupleSet.clone());
                        tupleSet = (TupleSet)((Value)object2).objectValue();
                    }
                    tupleSet.setName(variableArray[n].getName());
                    tupleSet.removeDuplicates();
                }
                variableArray[n].setValue((Value)object2);
            }
            return Value.EVAL;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            for (int i = 0; i < variableArray.length; ++i) {
                if (variableArray[i].getValue() != null) continue;
                scope.removeVariable(variableArray[i]);
            }
            throw new EvaluationException(this.lefts[n], variableArray[n].getName() + " not assigned a value");
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getIndent());
        if (this.lefts.length == 1) {
            stringBuffer.append(this.lefts[0]);
        } else {
            stringBuffer.append('(');
            for (int i = 0; i < this.lefts.length; ++i) {
                stringBuffer.append(this.lefts[i]);
                stringBuffer.append(", ");
            }
            stringBuffer.delete(stringBuffer.length() - 2, stringBuffer.length());
            stringBuffer.append(')');
        }
        stringBuffer.append(" = ");
        stringBuffer.append(this.expNode);
        return stringBuffer.toString();
    }
}

