/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.ql.interp;

import ca.uwaterloo.cs.ql.fb.AlgebraOperation;
import ca.uwaterloo.cs.ql.fb.TupleSet;
import ca.uwaterloo.cs.ql.interp.Env;
import ca.uwaterloo.cs.ql.interp.ErrorMessage;
import ca.uwaterloo.cs.ql.interp.EvaluationException;
import ca.uwaterloo.cs.ql.interp.ExpressionNode;
import ca.uwaterloo.cs.ql.interp.LookupException;
import ca.uwaterloo.cs.ql.interp.Operation;
import ca.uwaterloo.cs.ql.interp.Operator;
import ca.uwaterloo.cs.ql.interp.Scope;
import ca.uwaterloo.cs.ql.interp.StatementNode;
import ca.uwaterloo.cs.ql.interp.TypeOperation;
import ca.uwaterloo.cs.ql.interp.Value;
import ca.uwaterloo.cs.ql.interp.Variable;
import ca.uwaterloo.cs.ql.interp.VariableNode;

public class AssignmentExtensionNode
extends StatementNode {
    int op;
    VariableNode left;
    ExpressionNode expNode;

    public AssignmentExtensionNode(int n, VariableNode variableNode, ExpressionNode expressionNode) {
        this.op = n;
        this.left = variableNode;
        this.expNode = expressionNode;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Value evaluate(Env env) throws EvaluationException {
        Variable variable;
        String string;
        Scope scope = env.peepScope();
        try {
            string = this.left.evalName(env);
        }
        catch (EvaluationException evaluationException) {
            string = this.left.toString();
        }
        try {
            variable = scope.lookup(string);
        }
        catch (LookupException lookupException) {
            throw new EvaluationException(this, lookupException.getMessage());
        }
        Value value = variable.getValue();
        Value value2 = this.expNode.evaluate(env);
        if (value.isPrimitive() && value2.isPrimitive()) {
            int n = this.op;
            TypeOperation typeOperation = null;
            switch (this.op) {
                case 23: {
                    n = 12;
                    break;
                }
                case 24: {
                    n = 13;
                    break;
                }
                case 25: {
                    n = 15;
                    break;
                }
                case 26: {
                    n = 18;
                    break;
                }
            }
            typeOperation = TypeOperation.analyze(n, value.getType(), value2.getType());
            if (typeOperation == null) {
                String string2 = ErrorMessage.errUnsupportedOperation(this.op, value.getType(), value2.getType());
                throw new EvaluationException(this, string2);
            }
            try {
                Operation operation = typeOperation.getOperation();
                variable.setValue(operation.eval(n, value, value2));
                return Value.EVAL;
            }
            catch (Exception exception) {
                throw new EvaluationException(this, exception.getMessage());
            }
        }
        Object object = value.objectValue();
        Object object2 = value2.objectValue();
        if (object instanceof TupleSet && object2 instanceof TupleSet && this.op == 23) {
            Value value3 = new Value(AlgebraOperation.append((TupleSet)object, (TupleSet)object2));
            variable.setValue(value3);
            return Value.EVAL;
        }
        String string3 = ErrorMessage.errUnsupportedOperation(this.op, value.getType(), value2.getType());
        throw new EvaluationException(this, string3);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getIndent());
        stringBuffer.append(this.left);
        stringBuffer.append(' ');
        stringBuffer.append(Operator.key(this.op));
        stringBuffer.append(' ');
        stringBuffer.append(this.expNode);
        return stringBuffer.toString();
    }
}

