/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.ql.interp;

import ca.uwaterloo.cs.ql.interp.Env;
import ca.uwaterloo.cs.ql.interp.EvaluationException;
import ca.uwaterloo.cs.ql.interp.ExpressionNode;
import ca.uwaterloo.cs.ql.interp.Value;

public class ArgumentsNode
extends ExpressionNode {
    ExpressionNode[] args;

    public ArgumentsNode(ExpressionNode[] expressionNodeArray) {
        this.args = expressionNodeArray;
        if (expressionNodeArray == null) {
            this.args = new ExpressionNode[0];
        }
    }

    public ExpressionNode[] getArguments() {
        return this.args;
    }

    public void propagate(Env env, Object object) throws EvaluationException {
        for (int i = 0; i < this.args.length; ++i) {
            this.args[i].propagate(env, object);
        }
    }

    public Value evaluate(Env env) throws EvaluationException {
        Value[] valueArray = new Value[this.args.length];
        for (int i = 0; i < this.args.length; ++i) {
            valueArray[i] = this.args[i].evaluate(env);
        }
        if (this.args.length == 1) {
            return valueArray[0];
        }
        return new Value(valueArray);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        for (int i = 0; i < this.args.length; ++i) {
            stringBuffer.append(this.args[i]);
            stringBuffer.append(", ");
        }
        if (this.args.length == 0) {
            stringBuffer.append(')');
        } else {
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
            stringBuffer.setCharAt(stringBuffer.length() - 1, ')');
        }
        return stringBuffer.toString();
    }
}

