/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.ql.interp;

import ca.uwaterloo.cs.ql.interp.Env;
import ca.uwaterloo.cs.ql.interp.ErrorMessage;
import ca.uwaterloo.cs.ql.interp.EvaluationException;
import ca.uwaterloo.cs.ql.interp.ExpressionNode;
import ca.uwaterloo.cs.ql.interp.Operation;
import ca.uwaterloo.cs.ql.interp.Operator;
import ca.uwaterloo.cs.ql.interp.TypeOperation;
import ca.uwaterloo.cs.ql.interp.Value;

public class AdditiveExpressionNode
extends ExpressionNode {
    int op;
    ExpressionNode left;
    ExpressionNode right;

    public AdditiveExpressionNode(int n, ExpressionNode expressionNode, ExpressionNode expressionNode2) {
        this.op = n;
        this.left = expressionNode;
        this.right = expressionNode2;
    }

    public void propagate(Env env, Object object) throws EvaluationException {
        this.left.propagate(env, object);
        this.right.propagate(env, object);
    }

    public Value evaluate(Env env) throws EvaluationException {
        Value value = this.left.evaluate(env);
        Value value2 = this.right.evaluate(env);
        TypeOperation typeOperation = TypeOperation.analyze(this.op, value.getType(), value2.getType());
        if (typeOperation != null) {
            try {
                Operation operation = typeOperation.getOperation();
                return operation.eval(this.op, value, value2);
            }
            catch (Exception exception) {
                throw new EvaluationException(this, exception.getMessage());
            }
        }
        String string = ErrorMessage.errUnsupportedOperation(this.op, value.getType(), value2.getType());
        throw new EvaluationException(this, string);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.left);
        stringBuffer.append(" ");
        stringBuffer.append(Operator.key(this.op));
        stringBuffer.append(" ");
        stringBuffer.append(this.right);
        return stringBuffer.toString();
    }
}

