/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.ql.fb;

import ca.uwaterloo.cs.ql.fb.EdgeSet;
import ca.uwaterloo.cs.ql.fb.IDManager;
import ca.uwaterloo.cs.ql.fb.NodeSet;
import ca.uwaterloo.cs.ql.fb.RadixSorter;
import ca.uwaterloo.cs.ql.fb.Tuple;
import ca.uwaterloo.cs.ql.fb.TupleImpl;
import ca.uwaterloo.cs.ql.fb.TupleList;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;

public class TupleSet
implements Cloneable {
    public static final int CHAOS = 0;
    public static final int HAS_DUPLICATES = 4;
    protected String name = "?";
    protected int flags = 0;
    protected int sortLevel = -1;
    protected TupleList data;

    public TupleSet() {
        this.data = new TupleList(5);
    }

    public TupleSet(int n) {
        this.data = new TupleList(n);
    }

    public TupleSet(String string) {
        if (string != null) {
            this.name = string;
        }
        this.data = new TupleList(5);
    }

    public boolean hasName() {
        return this.name != null && this.name != "?";
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        if (string != null) {
            this.name = string;
        }
    }

    public void setFlag(int n) {
        this.flags = n == 0 ? n : (this.flags |= n);
    }

    public void unsetFlag(int n) {
        this.flags &= ~n;
    }

    public boolean hasDuplicates() {
        if (this.flags == 0) {
            this.setFlag(4);
        }
        return (this.flags & 4) != 0;
    }

    public void setHasDuplicates(boolean bl) {
        if (bl) {
            this.setFlag(4);
        } else {
            this.unsetFlag(4);
        }
    }

    public int size() {
        return this.data.size();
    }

    public int columns() {
        if (this.size() > 0) {
            Tuple tuple = this.data.getList().get(0);
            return tuple.size();
        }
        if (this instanceof NodeSet) {
            return 1;
        }
        if (this instanceof EdgeSet) {
            return 2;
        }
        return 0;
    }

    public void add(Tuple tuple) {
        if (tuple != null) {
            this.data.add(tuple);
            this.flags = 0;
            this.sortLevel = -1;
        }
    }

    public Tuple get(int n) {
        return this.data.get(n);
    }

    public Tuple[] getAllTuples() {
        int n = this.size();
        Tuple[] tupleArray = new Tuple[n];
        for (int i = 0; i < n; ++i) {
            tupleArray[i] = this.data.get(i);
        }
        return tupleArray;
    }

    public TupleList getTupleList() {
        return this.data;
    }

    public TupleSet newSet() {
        TupleSet tupleSet = new TupleSet();
        return tupleSet;
    }

    public Object clone() {
        TupleSet tupleSet = this.newSet();
        tupleSet.name = this.name;
        tupleSet.flags = this.flags;
        tupleSet.data = (TupleList)this.data.clone();
        return tupleSet;
    }

    protected void sort() {
        this.data.sort();
        this.sortLevel = this.size() > 1 ? (this.data.get(0).size() == this.data.get(this.size() - 1).size() ? 0 : -1) : 0;
    }

    protected void sortDom() {
        this.trySort(0);
    }

    protected void sortRng() {
        TupleList tupleList = new TupleList(this.data.size());
        RadixSorter.sortRng(this.data, tupleList);
        this.sortLevel = -1;
        this.data = tupleList;
    }

    protected void trySort(int n) {
        if (this.sortLevel != n) {
            this.sortLevel = n;
            TupleList tupleList = new TupleList(this.data.size());
            RadixSorter.sort(this.data, n, tupleList);
            this.data = tupleList;
        }
    }

    public void removeDuplicates() {
        if (this.hasDuplicates()) {
            this.sort();
            this.data.removeDuplicates();
            this.unsetFlag(4);
        }
    }

    public void print(OutputStream outputStream) {
        StringBuffer stringBuffer = new StringBuffer();
        PrintWriter printWriter = new PrintWriter(outputStream, true);
        int n = this.data.size();
        for (int i = 0; i < n; ++i) {
            Tuple tuple = this.data.get(i);
            stringBuffer.delete(0, stringBuffer.length());
            stringBuffer.append(IDManager.get(tuple.get(0)));
            for (int j = 1; j < tuple.size(); ++j) {
                stringBuffer.append(' ');
                stringBuffer.append(IDManager.get(tuple.get(j)));
            }
            printWriter.println(stringBuffer);
        }
        printWriter.flush();
    }

    public void printTA(OutputStream outputStream) {
        StringBuffer stringBuffer = new StringBuffer(this.name);
        PrintWriter printWriter = new PrintWriter(outputStream, true);
        int n = this.data.size();
        int n2 = this.name.length();
        for (int i = 0; i < n; ++i) {
            Tuple tuple = this.data.get(i);
            stringBuffer.delete(n2, stringBuffer.length());
            for (int j = 0; j < tuple.size(); ++j) {
                stringBuffer.append(' ');
                stringBuffer.append(IDManager.get(tuple.get(j)));
            }
            printWriter.println(stringBuffer);
        }
        printWriter.flush();
    }

    public void appendTA(String string) throws IOException {
        StringBuffer stringBuffer = new StringBuffer(this.name);
        RandomAccessFile randomAccessFile = new RandomAccessFile(new File(string), "rw");
        randomAccessFile.seek(randomAccessFile.length());
        int n = this.data.size();
        int n2 = this.name.length();
        if (n > 0) {
            randomAccessFile.writeBytes("FACT TUPLE :\n");
        }
        for (int i = 0; i < n; ++i) {
            Tuple tuple = this.data.get(i);
            stringBuffer.delete(n2, stringBuffer.length());
            for (int j = 0; j < tuple.size(); ++j) {
                stringBuffer.append(' ');
                stringBuffer.append(IDManager.get(tuple.get(j)));
            }
            randomAccessFile.writeBytes(stringBuffer + "\n");
        }
        randomAccessFile.close();
    }

    public void appendDB(String string) throws IOException {
        StringBuffer stringBuffer = new StringBuffer(this.name);
        RandomAccessFile randomAccessFile = new RandomAccessFile(new File(string), "rw");
        randomAccessFile.seek(randomAccessFile.length());
        int n = this.data.size();
        int n2 = this.name.length();
        for (int i = 0; i < n; ++i) {
            Tuple tuple = this.data.get(i);
            stringBuffer.delete(n2, stringBuffer.length());
            for (int j = 0; j < tuple.size(); ++j) {
                stringBuffer.append(' ');
                stringBuffer.append(IDManager.get(tuple.get(j)));
            }
            randomAccessFile.writeBytes(stringBuffer + "\n");
        }
        randomAccessFile.close();
    }

    public void add(String[] stringArray) {
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            nArray[i] = IDManager.getID(stringArray[i]);
        }
        this.data.add(new TupleImpl(nArray, false));
        this.sortLevel = -1;
        this.flags = 0;
    }
}

