/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.ql.fb;

import ca.uwaterloo.cs.ql.fb.RadixSorter;
import ca.uwaterloo.cs.ql.fb.Tuple;
import ca.uwaterloo.cs.ql.fb.Tuple4Node;
import ca.uwaterloo.cs.ql.fb.TupleImpl;
import ca.uwaterloo.cs.ql.fb.TupleSelector;
import java.util.ArrayList;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TupleList
implements Cloneable {
    private ArrayList<Tuple> listBody;

    public TupleList() {
        this.listBody = new ArrayList();
    }

    public TupleList(int n) {
        this.listBody = new ArrayList(n);
    }

    public Tuple get(int n) {
        return this.listBody.get(n);
    }

    public void add(Tuple tuple) {
        this.listBody.add(tuple);
    }

    public void addAll(TupleList tupleList) {
        this.listBody.addAll(tupleList.getList());
    }

    public int size() {
        return this.listBody.size();
    }

    public void clear() {
        this.listBody = new ArrayList();
    }

    public Object clone() {
        int n = this.size();
        TupleList tupleList = new TupleList(n);
        ArrayList<Tuple> arrayList = tupleList.listBody;
        for (int i = 0; i < n; ++i) {
            arrayList.add((Tuple)this.listBody.get(i).clone());
        }
        return tupleList;
    }

    public Object[] toArray() {
        return this.listBody.toArray();
    }

    public boolean isEmpty() {
        return this.listBody.isEmpty();
    }

    public Iterator iterator() {
        return this.listBody.iterator();
    }

    void reinit(TupleList tupleList) {
        this.listBody = new ArrayList(tupleList.size());
        this.listBody.addAll(tupleList.getList());
    }

    ArrayList<Tuple> getList() {
        return this.listBody;
    }

    void setList(ArrayList<Tuple> arrayList) {
        this.listBody = arrayList;
    }

    TupleList getTupleList(int n) throws IndexOutOfBoundsException {
        int n2 = this.size();
        TupleList tupleList = new TupleList(n2);
        for (int i = 0; i < n2; ++i) {
            int n3 = this.listBody.get(i).get(n);
            Tuple4Node tuple4Node = new Tuple4Node(n3);
            tupleList.add(tuple4Node);
        }
        return tupleList;
    }

    TupleList getTupleList(int[] nArray) throws IndexOutOfBoundsException {
        TupleList tupleList;
        if (nArray.length == 1) {
            tupleList = this.getTupleList(nArray[0]);
        } else {
            int n = this.size();
            tupleList = new TupleList(n);
            for (int i = 0; i < n; ++i) {
                int[] nArray2 = this.listBody.get(i).get(nArray);
                TupleImpl tupleImpl = new TupleImpl(nArray2, false);
                tupleList.add(tupleImpl);
            }
        }
        return tupleList;
    }

    public TupleList select(TupleSelector tupleSelector) {
        TupleList tupleList = new TupleList();
        if (tupleSelector == null) {
            return tupleList;
        }
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            Tuple tuple = this.listBody.get(i);
            if (!tupleSelector.select(tuple)) continue;
            tupleList.add(tuple);
        }
        return tupleList;
    }

    void sort() {
        int n = this.listBody.size();
        TupleList tupleList = new TupleList(n);
        if (n > 0) {
            RadixSorter.sort(this, tupleList);
            this.listBody = tupleList.listBody;
        }
    }

    void sort(int n) {
        int n2 = this.listBody.size();
        TupleList tupleList = new TupleList(n2);
        if (n2 > 0) {
            RadixSorter.sort(this, n, tupleList);
            this.listBody = tupleList.listBody;
        }
    }

    TupleList removeDuplicates() {
        int n = this.listBody.size();
        TupleList tupleList = new TupleList();
        if (n > 0) {
            ArrayList<Tuple> arrayList = new ArrayList<Tuple>(this.size());
            Tuple tuple = this.listBody.get(0);
            arrayList.add(tuple);
            for (int i = 1; i < n; ++i) {
                Tuple tuple2 = this.listBody.get(i);
                if (tuple.compareTo(tuple2) != 0) {
                    arrayList.add(tuple2);
                } else {
                    tupleList.add(tuple2);
                }
                tuple = tuple2;
            }
            this.listBody = arrayList;
        }
        return tupleList;
    }

    TupleList sort_removeDuplicates() {
        this.sort();
        return this.removeDuplicates();
    }
}

