/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.ql.fb;

import ca.uwaterloo.cs.ql.fb.EdgeSet;
import ca.uwaterloo.cs.ql.fb.IDManager;
import ca.uwaterloo.cs.ql.fb.Tuple;
import ca.uwaterloo.cs.ql.fb.TupleList;
import java.util.ArrayList;
import java.util.HashMap;

public class Tree {
    private int[] theRoots;
    private TupleList tlist;
    private MiniTable table;

    public Tree(EdgeSet edgeSet) {
        edgeSet.trySort(0);
        this.tlist = edgeSet.data;
        this.table = new MiniTable();
        this.init();
    }

    private void init() {
        int n = this.tlist.size();
        for (int i = 0; i < n; ++i) {
            Tuple tuple = this.tlist.get(i);
            int n2 = tuple.getDom();
            int n3 = tuple.getRng();
            Entry entry = this.table.putNode(n2);
            if (entry.outIndex == -1) {
                entry.outIndex = i;
            }
            entry = this.table.putNode(n3);
            entry.parent = n2;
        }
    }

    public int[] getRoots() {
        Entry entry;
        int n;
        if (this.theRoots != null) {
            return (int[])this.theRoots.clone();
        }
        ArrayList<Entry> arrayList = this.table.entryList;
        ArrayList<Entry> arrayList2 = new ArrayList<Entry>(2);
        int n2 = arrayList.size();
        for (n = 0; n < n2; ++n) {
            entry = arrayList.get(n);
            if (entry.parent != -1) continue;
            arrayList2.add(entry);
        }
        n2 = arrayList2.size();
        this.theRoots = new int[n2];
        for (n = 0; n < n2; ++n) {
            entry = (Entry)arrayList2.get(n);
            this.theRoots[n] = entry.node;
        }
        return (int[])this.theRoots.clone();
    }

    public int getParent(int n) {
        Entry entry = this.table.getNode(n);
        if (entry == null) {
            return -1;
        }
        return entry.parent;
    }

    public int[] getChildren(int n) {
        Tuple tuple;
        int n2;
        int n3 = n;
        Entry entry = this.table.getNode(n3);
        if (entry == null) {
            return new int[0];
        }
        if (entry.outIndex == -1) {
            return new int[0];
        }
        int n4 = this.tlist.size();
        ArrayList<Tuple> arrayList = new ArrayList<Tuple>(5);
        for (n2 = entry.outIndex; n2 < n4 && (tuple = this.tlist.get(n2)).getDom() == n3; ++n2) {
            arrayList.add(tuple);
        }
        n2 = arrayList.size();
        int[] nArray = new int[n2];
        for (int i = 0; i < n2; ++i) {
            tuple = (Tuple)arrayList.get(i);
            nArray[i] = tuple.getRng();
        }
        return nArray;
    }

    public EdgeSet getLevelRelation() {
        EdgeSet edgeSet = new EdgeSet();
        ArrayList<Entry> arrayList = this.table.entryList;
        this.setLevels();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Entry entry = arrayList.get(i);
            edgeSet.add(entry.node, IDManager.getID(entry.level + ""));
        }
        return edgeSet;
    }

    void setRoot(int n) {
        this.theRoots = new int[1];
        this.theRoots[0] = n;
    }

    void setLevels() {
        int[] nArray = this.getRoots();
        if (nArray.length == 1) {
            this.setLevel(nArray[0], 0);
        }
    }

    void setLevel(int n, int n2) {
        Entry entry = this.table.getNode(n);
        entry.level = n2;
        int[] nArray = this.getChildren(n);
        for (int i = 0; i < nArray.length; ++i) {
            this.setLevel(nArray[i], n2 + 1);
        }
    }

    Entry getEntry(int n) {
        return this.table.getNode(n);
    }

    static class Entry {
        int node;
        int level = -1;
        int parent = -1;
        int outIndex = -1;

        Entry(int n) {
            this.node = n;
        }
    }

    static class MiniTable {
        int s_index = 0;
        ArrayList<Entry> entryList = new ArrayList(1997);
        HashMap<String, Entry> allStrings = new HashMap(1997, 0.75f);

        MiniTable() {
        }

        Entry putNode(int n) {
            String string = n + "";
            Entry entry = this.allStrings.get(string);
            if (entry != null) {
                return entry;
            }
            entry = new Entry(n);
            this.entryList.add(this.s_index, entry);
            this.allStrings.put(string, entry);
            ++this.s_index;
            return entry;
        }

        Entry getNode(int n) {
            String string = n + "";
            return this.allStrings.get(string);
        }
    }
}

