/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.ql.fb;

import ca.uwaterloo.cs.ql.fb.Tuple;
import ca.uwaterloo.cs.ql.fb.Tuple4Edge;
import ca.uwaterloo.cs.ql.fb.Tuple4Node;
import ca.uwaterloo.cs.ql.fb.TupleList;
import java.util.ArrayList;
import java.util.HashMap;

class StringTable {
    private static int s_index = 0;
    private static StringTable instance = new StringTable(10007);
    private ArrayList<StringCell> nameList;
    private HashMap<String, StringCell> allStrings;

    static StringTable instance() {
        return instance;
    }

    private StringTable(int n) {
        this.nameList = new ArrayList(n);
        this.allStrings = new HashMap(n, 0.75f);
        this.add(null);
    }

    int size() {
        return this.nameList.size();
    }

    int add(String string) {
        StringCell stringCell = this.allStrings.get(string);
        if (stringCell != null) {
            return stringCell.index;
        }
        stringCell = new StringCell(s_index, string);
        this.nameList.add(s_index, stringCell);
        this.allStrings.put(string, stringCell);
        ++s_index;
        return stringCell.index;
    }

    int addComposite(String string) {
        StringCell stringCell = this.allStrings.get(string);
        if (stringCell != null) {
            return stringCell.index;
        }
        stringCell = new StringCell(s_index, string);
        stringCell.composite = true;
        this.nameList.add(s_index, stringCell);
        this.allStrings.put(string, stringCell);
        ++s_index;
        return stringCell.index;
    }

    String get(int n) {
        StringCell stringCell = this.nameList.get(n);
        return stringCell.name;
    }

    int getReplace(int n) {
        StringCell stringCell = this.nameList.get(n);
        return stringCell.replace;
    }

    void setReplace(int n, int n2) {
        StringCell stringCell = this.nameList.get(n);
        stringCell.replace = n2;
    }

    void initReplace(TupleList tupleList) {
        int n = tupleList.size();
        for (int i = 0; i < n; ++i) {
            Tuple tuple = tupleList.get(i);
            this.setReplace(tuple.getDom(), tuple.getRng());
        }
    }

    void closeReplace() {
        for (int i = 0; i < s_index; ++i) {
            this.setReplace(i, i);
        }
    }

    boolean isComposite(int n) {
        StringCell stringCell = this.nameList.get(n);
        return stringCell.composite;
    }

    TupleList getID() {
        TupleList tupleList = new TupleList(s_index);
        for (int i = 0; i < s_index; ++i) {
            tupleList.add(new Tuple4Edge(i, i));
        }
        return tupleList;
    }

    TupleList getENT() {
        TupleList tupleList = new TupleList(s_index);
        for (int i = 0; i < s_index; ++i) {
            tupleList.add(new Tuple4Node(i));
        }
        return tupleList;
    }

    TupleList getAllComposites() {
        TupleList tupleList = new TupleList();
        for (int i = 0; i < s_index; ++i) {
            if (!this.isComposite(i)) continue;
            tupleList.add(new Tuple4Node(i));
        }
        return tupleList;
    }

    class StringCell {
        int index = 0;
        int replace = 0;
        String name = null;
        boolean composite = false;

        StringCell(int n, String string) {
            this.name = string;
            this.index = n;
            this.replace = n;
        }
    }
}

