/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.ql.fb;

import ca.uwaterloo.cs.ql.fb.AlgebraOperation;
import ca.uwaterloo.cs.ql.fb.EdgeSet;
import ca.uwaterloo.cs.ql.fb.IDManager;
import ca.uwaterloo.cs.ql.fb.NodeSet;
import ca.uwaterloo.cs.ql.fb.Operation;
import ca.uwaterloo.cs.ql.fb.RadixSorter;
import ca.uwaterloo.cs.ql.fb.Tuple;
import ca.uwaterloo.cs.ql.fb.Tuple4Edge;
import ca.uwaterloo.cs.ql.fb.Tuple4Node;
import ca.uwaterloo.cs.ql.fb.TupleList;
import java.util.StringTokenizer;

public class SpecialOperation {
    public static int encode(NodeSet nodeSet) {
        nodeSet.trySort(0);
        return SpecialOperation.encodeID(nodeSet.data);
    }

    public static NodeSet decode(int n) {
        NodeSet nodeSet = new NodeSet();
        nodeSet.data = SpecialOperation.decodeID(n);
        nodeSet.sortLevel = 0;
        return nodeSet;
    }

    public static NodeSet basket(String string) {
        NodeSet nodeSet = null;
        if (string.length() > 0 && string.charAt(0) == '(' && string.charAt(string.length() - 1) == ')') {
            String string2 = string.substring(1, string.length() - 1);
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            NodeSet nodeSet2 = new NodeSet();
            while (stringTokenizer.hasMoreTokens()) {
                nodeSet2.add(stringTokenizer.nextToken());
            }
            if (nodeSet2.size() > 0) {
                nodeSet = NodeSet.singleton(SpecialOperation.encode(nodeSet2));
            }
        }
        if (nodeSet == null) {
            nodeSet = new NodeSet();
        }
        return nodeSet;
    }

    public static NodeSet basket(NodeSet nodeSet) {
        NodeSet nodeSet2;
        if (nodeSet.size() > 0) {
            nodeSet2 = NodeSet.singleton(SpecialOperation.encode(nodeSet));
            nodeSet2.sortLevel = 0;
        } else {
            nodeSet2 = new NodeSet();
        }
        nodeSet2.setHasDuplicates(false);
        return nodeSet2;
    }

    public static EdgeSet basket(EdgeSet edgeSet) {
        EdgeSet edgeSet2 = new EdgeSet();
        edgeSet.trySort(0);
        edgeSet2.data = SpecialOperation.basket(edgeSet.data);
        edgeSet2.setHasDuplicates(false);
        edgeSet2.sortLevel = 0;
        return edgeSet2;
    }

    public static NodeSet unbasket(String string) {
        NodeSet nodeSet = new NodeSet();
        if (string.length() > 0 && string.charAt(0) == '(' && string.charAt(string.length() - 1) == ')') {
            String string2 = string.substring(1, string.length() - 1);
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            while (stringTokenizer.hasMoreTokens()) {
                nodeSet.add(stringTokenizer.nextToken());
            }
        }
        return nodeSet;
    }

    public static NodeSet unbasket(NodeSet nodeSet) {
        NodeSet nodeSet2 = new NodeSet();
        TupleList tupleList = nodeSet.data;
        for (int i = 0; i < tupleList.size(); ++i) {
            int n = tupleList.get(i).getDom();
            int[] nArray = IDManager.parse(n);
            for (int j = 0; j < nArray.length; ++j) {
                nodeSet2.add(nArray[j]);
            }
        }
        return nodeSet2;
    }

    public static EdgeSet unbasket(EdgeSet edgeSet) {
        EdgeSet edgeSet2 = new EdgeSet();
        TupleList tupleList = edgeSet.data;
        for (int i = 0; i < tupleList.size(); ++i) {
            Tuple tuple = tupleList.get(i);
            int n = tuple.getDom();
            int n2 = tuple.getRng();
            int[] nArray = IDManager.parse(n2);
            for (int j = 0; j < nArray.length; ++j) {
                edgeSet2.add(n, nArray[j]);
            }
        }
        return edgeSet2;
    }

    public static EdgeSet lattice(NodeSet nodeSet) {
        EdgeSet edgeSet = new EdgeSet();
        TupleList tupleList = nodeSet.data;
        int n = tupleList.size();
        for (int i = 0; i < n - 1; ++i) {
            int n2 = tupleList.get(i).getDom();
            NodeSet nodeSet2 = SpecialOperation.decode(n2);
            for (int j = i + 1; j < n; ++j) {
                int n3 = tupleList.get(j).getDom();
                NodeSet nodeSet3 = SpecialOperation.decode(n3);
                int n4 = Operation.comparison(nodeSet2.data, nodeSet3.data);
                if (n4 == -1) {
                    edgeSet.data.add(new Tuple4Edge(n3, n2));
                    continue;
                }
                if (n4 != 1) continue;
                edgeSet.data.add(new Tuple4Edge(n2, n3));
            }
        }
        return AlgebraOperation.unclosure(edgeSet);
    }

    static int encodeID(TupleList tupleList) {
        int n = tupleList.size();
        if (n > 0) {
            int[] nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = tupleList.get(i).getDom();
            }
            return IDManager.getID(nArray);
        }
        return 0;
    }

    static TupleList decodeID(int n) {
        int[] nArray = IDManager.parse(n);
        TupleList tupleList = new TupleList(nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            tupleList.add(new Tuple4Node(nArray[i]));
        }
        return tupleList;
    }

    static TupleList basket(TupleList tupleList) {
        int n = tupleList.size();
        TupleList tupleList2 = new TupleList();
        TupleList tupleList3 = new TupleList();
        if (n > 0) {
            Tuple tuple = tupleList.get(0);
            int n2 = tuple.getDom();
            tupleList3.add(new Tuple4Node(tuple.getRng()));
            for (int i = 1; i < n; ++i) {
                tuple = tupleList.get(i);
                int n3 = tuple.getDom();
                if (n2 == n3) {
                    tupleList3.add(new Tuple4Node(tuple.getRng()));
                    continue;
                }
                RadixSorter.sort(tupleList3, 0, tupleList3);
                tupleList2.add(new Tuple4Edge(n2, SpecialOperation.encodeID(tupleList3)));
                tupleList3.clear();
                n2 = n3;
                tupleList3.add(new Tuple4Node(tuple.getRng()));
            }
            RadixSorter.sort(tupleList3, 0, tupleList3);
            tupleList2.add(new Tuple4Edge(n2, SpecialOperation.encodeID(tupleList3)));
        }
        return tupleList2;
    }
}

