/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.ql.fb;

import ca.uwaterloo.cs.ql.fb.BinarySearch;
import ca.uwaterloo.cs.ql.fb.EdgeSet;
import ca.uwaterloo.cs.ql.fb.IDManager;
import ca.uwaterloo.cs.ql.fb.RadixSorter;
import ca.uwaterloo.cs.ql.fb.Tuple;
import ca.uwaterloo.cs.ql.fb.TupleImpl;
import ca.uwaterloo.cs.ql.fb.TupleList;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Show {
    TupleList shadow;
    TupleList attList;
    TupleList relList;
    TupleList nameList;
    StringBuffer buffer;
    int name_ID = IDManager.getID("@name");
    int inst_ID = IDManager.getID("$INSTANCE");

    public Show() {
        this.buffer = new StringBuffer();
        this.attList = new TupleList(1000);
        this.relList = new TupleList(1000);
    }

    public void addRels(EdgeSet edgeSet) {
        TupleList tupleList = edgeSet.data;
        int n = tupleList.size();
        int[] nArray = new int[3];
        nArray[0] = IDManager.getID(edgeSet.getName());
        for (int i = 0; i < n; ++i) {
            Tuple tuple = tupleList.get(i);
            nArray[1] = tuple.getDom();
            nArray[2] = tuple.getRng();
            TupleImpl tupleImpl = new TupleImpl(nArray);
            this.relList.add(tupleImpl);
        }
    }

    public void addAtts(EdgeSet edgeSet) {
        TupleList tupleList = edgeSet.data;
        int n = tupleList.size();
        int[] nArray = new int[3];
        nArray[0] = IDManager.getID(edgeSet.getName());
        if (nArray[0] == this.name_ID) {
            this.nameList = (TupleList)tupleList.clone();
        }
        for (int i = 0; i < n; ++i) {
            Tuple tuple = tupleList.get(i);
            nArray[1] = tuple.getDom();
            nArray[2] = tuple.getRng();
            TupleImpl tupleImpl = new TupleImpl(nArray);
            this.attList.add(tupleImpl);
        }
    }

    public void setup() {
        TupleList tupleList;
        if (this.nameList != null) {
            tupleList = new TupleList(this.nameList.size());
            RadixSorter.sort(this.nameList, 0, tupleList);
            this.nameList = tupleList;
        }
        tupleList = new TupleList(this.attList.size());
        RadixSorter.sort(this.attList, 0, tupleList);
        this.attList = new TupleList(tupleList.size());
        RadixSorter.sort(tupleList, 1, this.attList);
        tupleList = new TupleList(this.relList.size());
        RadixSorter.sort(this.relList, 0, tupleList);
        this.relList = new TupleList(tupleList.size());
        RadixSorter.sort(tupleList, 1, this.relList);
        this.shadow = new TupleList(tupleList.size());
        RadixSorter.sort(tupleList, 2, this.shadow);
    }

    public String getName(int n) {
        if (this.nameList == null) {
            return null;
        }
        int n2 = BinarySearch.search(this.nameList, n, 0);
        if (n2 < 0) {
            return null;
        }
        return IDManager.get(this.nameList.get(n2).get(1));
    }

    public String[] getAtts(int n) {
        Tuple tuple;
        String[] stringArray = new String[]{null, null, null};
        int n2 = BinarySearch.search(this.attList, n, 1);
        if (n2 < 0) {
            return stringArray;
        }
        this.buffer.delete(0, this.buffer.length());
        this.buffer.append("{ ");
        while (n2 < this.attList.size() && (tuple = this.attList.get(n2)).get(1) == n) {
            int n3 = tuple.get(0);
            if (n3 == this.name_ID) {
                stringArray[0] = IDManager.get(tuple.get(2));
            } else if (n3 == this.inst_ID) {
                stringArray[1] = IDManager.get(tuple.get(2));
            } else {
                this.buffer.append(IDManager.get(n3).substring(1));
                this.buffer.append('=');
                this.buffer.append(IDManager.get(tuple.get(2)));
                this.buffer.append(' ');
            }
            ++n2;
        }
        if (this.buffer.length() > 2) {
            this.buffer.append("}");
            stringArray[2] = this.buffer.toString();
        }
        return stringArray;
    }

    public ArrayList<String> getRels(int n) {
        String string;
        Tuple tuple;
        int n2;
        ArrayList<String> arrayList = new ArrayList<String>();
        int n3 = BinarySearch.search(this.relList, n, 1);
        if (n3 >= 0) {
            this.buffer.delete(0, this.buffer.length());
            this.buffer.append("( ");
            n2 = this.relList.size();
            while (n3 < n2 && (tuple = this.relList.get(n3)).get(1) == n) {
                this.buffer.delete(2, this.buffer.length());
                this.buffer.append(IDManager.get(tuple.get(0)));
                this.buffer.append(" -> ");
                string = this.getName(tuple.get(2));
                if (string != null) {
                    this.buffer.append(string);
                    this.buffer.append(" @ ");
                }
                this.buffer.append(IDManager.get(tuple.get(2)));
                this.buffer.append(" )");
                arrayList.add(this.buffer.toString());
                ++n3;
            }
        }
        if ((n3 = BinarySearch.search(this.shadow, n, 2)) >= 0) {
            this.buffer.delete(0, this.buffer.length());
            this.buffer.append("( ");
            n2 = this.shadow.size();
            while (n3 < n2 && (tuple = this.shadow.get(n3)).get(2) == n) {
                this.buffer.delete(2, this.buffer.length());
                this.buffer.append(IDManager.get(tuple.get(0)));
                this.buffer.append(" <- ");
                string = this.getName(tuple.get(1));
                if (string != null) {
                    this.buffer.append(string);
                    this.buffer.append(" @ ");
                }
                this.buffer.append(IDManager.get(tuple.get(1)));
                this.buffer.append(" )");
                arrayList.add(this.buffer.toString());
                ++n3;
            }
        }
        return arrayList;
    }

    public static String getAtt(int n, EdgeSet edgeSet) {
        if (edgeSet == null) {
            return null;
        }
        edgeSet.trySort(0);
        TupleList tupleList = edgeSet.data;
        int n2 = BinarySearch.search(tupleList, n, 0);
        if (n2 < 0) {
            return null;
        }
        return IDManager.get(tupleList.get(n2).get(1));
    }

    public static ArrayList<String> getRels(int n, EdgeSet edgeSet, EdgeSet edgeSet2) {
        String string;
        Tuple tuple;
        int n2;
        int n3;
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        TupleList tupleList = edgeSet.shadow();
        if (edgeSet.sortLevel % 2 != 0) {
            object = new TupleList(edgeSet.size());
            RadixSorter.sort(tupleList, 0, (TupleList)object);
            edgeSet.data = object;
            edgeSet.sortLevel = 2;
        }
        TupleList tupleList2 = edgeSet.data;
        object = new StringBuffer();
        ((StringBuffer)object).append("( ");
        ((StringBuffer)object).append(edgeSet.getName());
        int n4 = ((StringBuffer)object).length();
        int n5 = BinarySearch.search(tupleList2, n, 0);
        if (n5 >= 0) {
            int n6;
            ((StringBuffer)object).append(" -> ");
            n3 = ((StringBuffer)object).length();
            while (n5 > 0 && tupleList2.get(n6 = n5 - 1).get(0) == n) {
                n5 = n6;
            }
            n2 = tupleList2.size();
            while (n5 < n2 && (tuple = tupleList2.get(n5)).get(0) == n) {
                ((StringBuffer)object).delete(n3, ((StringBuffer)object).length());
                string = Show.getAtt(tuple.get(1), edgeSet2);
                if (string != null) {
                    ((StringBuffer)object).append(string);
                    ((StringBuffer)object).append(" @ ");
                }
                ((StringBuffer)object).append(IDManager.get(tuple.get(1)));
                ((StringBuffer)object).append(" )");
                arrayList.add(((StringBuffer)object).toString());
                ++n5;
            }
        }
        if ((n5 = BinarySearch.search(tupleList, n, 1)) >= 0) {
            ((StringBuffer)object).delete(n4, ((StringBuffer)object).length());
            ((StringBuffer)object).append(" <- ");
            n3 = ((StringBuffer)object).length();
            n2 = tupleList.size();
            while (n5 < n2 && (tuple = tupleList.get(n5)).get(1) == n) {
                ((StringBuffer)object).delete(n3, ((StringBuffer)object).length());
                string = Show.getAtt(tuple.get(0), edgeSet2);
                if (string != null) {
                    ((StringBuffer)object).append(string);
                    ((StringBuffer)object).append(" @ ");
                }
                ((StringBuffer)object).append(IDManager.get(tuple.get(0)));
                ((StringBuffer)object).append(" )");
                arrayList.add(((StringBuffer)object).toString());
                ++n5;
            }
        }
        return arrayList;
    }
}

