/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.ql.fb;

import ca.uwaterloo.cs.ql.fb.Cell;
import ca.uwaterloo.cs.ql.fb.Queue;
import ca.uwaterloo.cs.ql.fb.RadixItem;
import ca.uwaterloo.cs.ql.fb.Tuple;
import ca.uwaterloo.cs.ql.fb.TupleList;
import ca.uwaterloo.cs.ql.fb.TupleListMap;
import java.util.Iterator;

public class RadixSorter {
    public static void sort(TupleList tupleList, TupleList tupleList2) {
        TupleList tupleList3;
        int n;
        TupleListMap tupleListMap = new TupleListMap();
        RadixSorter.regroup(tupleList, tupleListMap);
        TupleList[] tupleListArray = tupleListMap.listArray;
        for (n = 0; n < tupleListArray.length; ++n) {
            tupleList3 = tupleListArray[n];
            if (tupleList3 == null) continue;
            RadixSorter.sortAll(tupleList3, tupleList3);
        }
        if (tupleList == tupleList2) {
            tupleList2.clear();
        }
        for (n = 0; n < tupleListArray.length; ++n) {
            tupleList3 = tupleListArray[n];
            if (tupleList3 == null) continue;
            tupleList2.addAll(tupleList3);
        }
    }

    private static void regroup(TupleList tupleList, TupleListMap tupleListMap) {
        int n = tupleList.size();
        for (int i = 0; i < n; ++i) {
            Tuple tuple = tupleList.get(i);
            TupleList tupleList2 = tupleListMap.getList(tuple.size());
            tupleList2.add(tuple);
        }
    }

    private static void sortAll(TupleList tupleList, TupleList tupleList2) {
        TupleList tupleList3 = tupleList;
        int n = tupleList.size();
        if (n > 0) {
            int n2 = tupleList.get(0).size();
            for (int i = n2 - 1; i >= 0; --i) {
                TupleList tupleList4 = new TupleList(n);
                RadixSorter.sort(tupleList3, i, tupleList4);
                tupleList3 = tupleList4;
            }
        }
        if (tupleList == tupleList2) {
            tupleList2.setList(tupleList3.getList());
        } else {
            tupleList2.addAll(tupleList3);
        }
    }

    public static void sortDom(TupleList tupleList, TupleList tupleList2) {
        RadixSorter.sort(tupleList, 0, tupleList2);
    }

    public static void sortRng(TupleList tupleList, TupleList tupleList2) {
        Queue queue = new Queue();
        Queue[] queueArray = new Queue[10];
        int n = 0;
        int n2 = RadixSorter.initQueueRng(queue, tupleList);
        while (n2 > 0) {
            n2 /= 10;
            ++n;
        }
        int n3 = tupleList.size();
        for (int i = 0; i < n; ++i) {
            int n4;
            for (n4 = 0; n4 < 10; ++n4) {
                queueArray[n4] = new Queue();
            }
            for (n4 = 0; n4 < n3; ++n4) {
                RadixItem radixItem = queue.dequeue();
                int n5 = radixItem.getValue();
                int n6 = RadixSorter.getLastDigit(n5);
                radixItem.setValue(RadixSorter.getPrefix(n5));
                queueArray[n6].enqueue(radixItem);
            }
            for (n4 = 0; n4 < 10; ++n4) {
                queue.append(queueArray[n4]);
            }
        }
        Cell cell = null;
        Cell cell2 = queue.trailer();
        if (cell2 == null) {
            return;
        }
        if (tupleList == tupleList2) {
            tupleList2.clear();
        }
        for (cell = cell2.getNext(); cell != cell2; cell = cell.getNext()) {
            tupleList2.add(cell.getItem().getTuple());
        }
        tupleList2.add(cell2.getItem().getTuple());
    }

    public static void sort(TupleList tupleList, int n, TupleList tupleList2) {
        Queue queue = new Queue();
        Queue[] queueArray = new Queue[10];
        int n2 = 0;
        int n3 = RadixSorter.initQueue(queue, tupleList, n);
        while (n3 > 0) {
            n3 /= 10;
            ++n2;
        }
        int n4 = tupleList.size();
        for (int i = 0; i < n2; ++i) {
            int n5;
            for (n5 = 0; n5 < 10; ++n5) {
                queueArray[n5] = new Queue();
            }
            for (n5 = 0; n5 < n4; ++n5) {
                RadixItem radixItem = queue.dequeue();
                int n6 = radixItem.getValue();
                int n7 = RadixSorter.getLastDigit(n6);
                radixItem.setValue(RadixSorter.getPrefix(n6));
                queueArray[n7].enqueue(radixItem);
            }
            for (n5 = 0; n5 < 10; ++n5) {
                queue.append(queueArray[n5]);
            }
        }
        Cell cell = null;
        Cell cell2 = queue.trailer();
        if (cell2 == null) {
            return;
        }
        if (tupleList == tupleList2) {
            tupleList2.clear();
        }
        for (cell = cell2.getNext(); cell != cell2; cell = cell.getNext()) {
            tupleList2.add(cell.getItem().getTuple());
        }
        tupleList2.add(cell2.getItem().getTuple());
    }

    static int getPrefix(int n) {
        return n / 10;
    }

    static int getLastDigit(int n) {
        return n % 10;
    }

    static int initQueue(Queue queue, TupleList tupleList, int n) {
        int n2 = 0;
        Iterator iterator = tupleList.iterator();
        while (iterator.hasNext()) {
            Tuple tuple = (Tuple)iterator.next();
            int n3 = n < tuple.size() ? tuple.get(n) : 0;
            if (n3 > n2) {
                n2 = n3;
            }
            queue.enqueue(new RadixItem(n3, tuple));
        }
        return n2;
    }

    static int initQueueRng(Queue queue, TupleList tupleList) {
        int n = 0;
        Iterator iterator = tupleList.iterator();
        while (iterator.hasNext()) {
            Tuple tuple = (Tuple)iterator.next();
            int n2 = tuple.getRng();
            if (n2 > n) {
                n = n2;
            }
            queue.enqueue(new RadixItem(n2, tuple));
        }
        return n;
    }
}

