/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.ql.fb;

import ca.uwaterloo.cs.ql.fb.BinarySearch;
import ca.uwaterloo.cs.ql.fb.EdgeSet;
import ca.uwaterloo.cs.ql.fb.IDManager;
import ca.uwaterloo.cs.ql.fb.Operation;
import ca.uwaterloo.cs.ql.fb.Path;
import ca.uwaterloo.cs.ql.fb.RadixSorter;
import ca.uwaterloo.cs.ql.fb.Tuple;
import ca.uwaterloo.cs.ql.fb.TupleCmpSimple;
import ca.uwaterloo.cs.ql.fb.TupleComparator;
import ca.uwaterloo.cs.ql.fb.TupleImpl;
import ca.uwaterloo.cs.ql.fb.TupleList;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathClosure {
    TupleList tertiary;
    TupleComparator tcmp;

    public PathClosure(EdgeSet edgeSet) {
        int[] nArray = new int[]{0, 2};
        this.tcmp = new TupleCmpSimple(nArray);
        this.tertiary = edgeSet == null ? new TupleList(5) : Operation.pathClosure(edgeSet.data);
        TupleList tupleList = new TupleList(this.tertiary.size());
        RadixSorter.sort(this.tertiary, 2, tupleList);
        this.tertiary = new TupleList(this.tertiary.size());
        RadixSorter.sort(tupleList, 0, this.tertiary);
    }

    public Path[] getPaths() {
        ArrayList<Path> arrayList = new ArrayList<Path>(this.tertiary.size());
        for (int i = 0; i < this.tertiary.size(); ++i) {
            Tuple tuple = this.tertiary.get(i);
            arrayList.addAll(this.getPaths(tuple.get(0), tuple.get(2)));
        }
        Path[] pathArray = new Path[arrayList.size()];
        arrayList.toArray(pathArray);
        return pathArray;
    }

    public Path[] getPaths(String string, String string2) {
        ArrayList<Path> arrayList = this.getPaths(IDManager.getID(string), IDManager.getID(string2));
        Path[] pathArray = new Path[arrayList.size()];
        arrayList.toArray(pathArray);
        return pathArray;
    }

    private ArrayList<Path> getPaths(int n, int n2) {
        int[] nArray = new int[]{n, 0, n2};
        ArrayList<Path> arrayList = new ArrayList<Path>();
        ArrayList<Path> arrayList2 = new ArrayList<Path>();
        TupleImpl tupleImpl = new TupleImpl(nArray);
        int n3 = this.search(tupleImpl);
        if (n3 >= 0) {
            Tuple tuple;
            for (int i = n3; i < this.tertiary.size() && this.tcmp.compare(tupleImpl, tuple = this.tertiary.get(i)) == 0; ++i) {
                if (this.isPrimitive(tuple)) {
                    arrayList2.add(Path.link(tuple.getDom(), tuple.getRng()));
                    continue;
                }
                arrayList.add(Path.link(tuple.getDom(), tuple.get(1)));
            }
            this.search(arrayList, arrayList2, nArray[2]);
            return arrayList2;
        }
        return new ArrayList<Path>(0);
    }

    private void search(ArrayList arrayList, ArrayList<Path> arrayList2, int n) {
        int[] nArray = new int[3];
        nArray[1] = 0;
        nArray[2] = n;
        ArrayList<Path> arrayList3 = new ArrayList<Path>();
        for (int i = 0; i < arrayList.size(); ++i) {
            Tuple tuple;
            Path path = (Path)arrayList.get(i);
            nArray[0] = path.tail();
            TupleImpl tupleImpl = new TupleImpl(nArray);
            int n2 = this.search(tupleImpl);
            if (n2 < 0) continue;
            while (n2 < this.tertiary.size() && this.tcmp.compare(tupleImpl, tuple = this.tertiary.get(n2)) == 0) {
                if (this.isPrimitive(tuple)) {
                    arrayList2.add(Path.link(path, n));
                } else if (!path.contains(tuple.get(1))) {
                    arrayList3.add(Path.link(path, tuple.get(1)));
                }
                ++n2;
            }
        }
        if (arrayList3.size() > 0) {
            this.search(arrayList3, arrayList2, n);
        }
    }

    private boolean isPrimitive(Tuple tuple) {
        return tuple.get(1) == 0;
    }

    private int search(Tuple tuple) {
        return BinarySearch.search(this.tertiary, tuple, this.tcmp);
    }
}

