/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.ql.fb;

import ca.uwaterloo.cs.ql.fb.IDManager;
import ca.uwaterloo.cs.ql.fb.Tuple;
import ca.uwaterloo.cs.ql.fb.TupleImpl;

public class Path {
    int[] vertices;

    private Path() {
    }

    public Path(int n) {
        this.vertices = new int[1];
        this.vertices[0] = n;
    }

    public Path(int[] nArray) {
        this.vertices = nArray;
    }

    public int head() {
        return this.vertices[0];
    }

    public int tail() {
        return this.vertices[this.length()];
    }

    public int length() {
        return this.vertices.length - 1;
    }

    public int countVertices() {
        return this.vertices.length;
    }

    public Tuple getTuple() {
        return new TupleImpl(this.vertices, false);
    }

    public boolean contains(int n) {
        for (int i = 0; i < this.vertices.length; ++i) {
            if (this.vertices[i] != n) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        int n = this.countVertices();
        StringBuffer stringBuffer = new StringBuffer();
        if (n > 0) {
            for (int i = 0; i < n - 1; ++i) {
                stringBuffer.append(IDManager.get(this.vertices[i]));
                stringBuffer.append(" -> ");
            }
            stringBuffer.append(IDManager.get(this.vertices[n - 1]));
        }
        return stringBuffer.toString();
    }

    public static Path link(Path path, Path path2) {
        Path path3 = new Path();
        path3.vertices = new int[path.countVertices() + path2.countVertices()];
        System.arraycopy(path.vertices, 0, path3.vertices, 0, path.countVertices());
        System.arraycopy(path2.vertices, 0, path3.vertices, path.countVertices(), path2.countVertices());
        return path3;
    }

    public static Path link(int n, Path path) {
        Path path2 = new Path();
        path2.vertices = new int[path.countVertices() + 1];
        path2.vertices[0] = n;
        System.arraycopy(path.vertices, 0, path2.vertices, 1, path.countVertices());
        return path2;
    }

    public static Path link(Path path, int n) {
        Path path2 = new Path();
        path2.vertices = new int[path.countVertices() + 1];
        System.arraycopy(path.vertices, 0, path2.vertices, 0, path.countVertices());
        path2.vertices[path.countVertices()] = n;
        return path2;
    }

    public static Path link(int n, int n2) {
        int[] nArray = new int[]{n, n2};
        return new Path(nArray);
    }
}

