/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.ql.fb;

import ca.uwaterloo.cs.ql.fb.BinarySearch;
import ca.uwaterloo.cs.ql.fb.EdgeSet;
import ca.uwaterloo.cs.ql.fb.RadixSorter;
import ca.uwaterloo.cs.ql.fb.Tuple;
import ca.uwaterloo.cs.ql.fb.Tuple4Edge;
import ca.uwaterloo.cs.ql.fb.TupleImpl;
import ca.uwaterloo.cs.ql.fb.TupleList;
import java.util.HashSet;

public class Partition {
    HashSet<Integer> hash = new HashSet(1997, 0.75f);
    TupleList tuplist;

    public int countPartitions(EdgeSet edgeSet) {
        if (edgeSet == null) {
            return 0;
        }
        this.hash.clear();
        this.tuplist = null;
        this.setup(edgeSet);
        int n = this.compute();
        return n;
    }

    public EdgeSet[] getPartitions(EdgeSet edgeSet) {
        if (edgeSet == null) {
            return new EdgeSet[0];
        }
        this.hash.clear();
        this.tuplist = null;
        this.setup(edgeSet);
        int n = this.compute();
        EdgeSet[] edgeSetArray = new EdgeSet[n];
        TupleList[] tupleListArray = new TupleList[n];
        for (int i = 0; i < n; ++i) {
            edgeSetArray[i] = new EdgeSet();
            tupleListArray[i] = edgeSetArray[i].data;
        }
        this.collect(tupleListArray);
        return edgeSetArray;
    }

    private void setup(EdgeSet edgeSet) {
        Tuple tuple;
        int n;
        TupleList tupleList = edgeSet.data;
        int n2 = tupleList.size();
        int[] nArray = new int[4];
        nArray[2] = -1;
        this.tuplist = new TupleList(n2 * 2);
        nArray[3] = 1;
        for (n = 0; n < n2; ++n) {
            tuple = tupleList.get(n);
            nArray[0] = tuple.getDom();
            nArray[1] = tuple.getRng();
            this.tuplist.add(new TupleImpl(nArray));
        }
        nArray[3] = 0;
        for (n = 0; n < n2; ++n) {
            tuple = tupleList.get(n);
            nArray[0] = tuple.getRng();
            nArray[1] = tuple.getDom();
            this.tuplist.add(new TupleImpl(nArray));
        }
        TupleList tupleList2 = new TupleList(n2 * 2);
        RadixSorter.sort(this.tuplist, 0, tupleList2);
        this.tuplist = tupleList2;
    }

    private int compute() {
        int n = 0;
        int n2 = this.tuplist.size();
        for (int i = 0; i < n2; ++i) {
            Tuple tuple = this.tuplist.get(i);
            if (tuple.get(2) >= 0) continue;
            this.reachGraph(tuple.get(0), n);
            ++n;
        }
        return n;
    }

    private void collect(TupleList[] tupleListArray) {
        int n = this.tuplist.size();
        for (int i = 0; i < n; ++i) {
            Tuple tuple = this.tuplist.get(i);
            if (tuple.get(3) != 1) continue;
            tupleListArray[tuple.get(2)].add(new Tuple4Edge(tuple.get(0), tuple.get(1)));
        }
    }

    private void reachGraph(int n, int n2) {
        Tuple tuple;
        Integer n3 = new Integer(n);
        if (this.hash.contains(n3)) {
            return;
        }
        this.hash.add(n3);
        int n4 = BinarySearch.search(this.tuplist, n, 0);
        if (n4 < 0) {
            return;
        }
        int n5 = this.tuplist.size();
        for (int i = n4; i < n5 && (tuple = this.tuplist.get(i)).get(0) == n; ++i) {
            tuple.set(2, n2);
            this.reachGraph(tuple.get(1), n2);
        }
    }
}

