/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.ql.fb;

import ca.uwaterloo.cs.ql.fb.AlgebraOperation;
import ca.uwaterloo.cs.ql.fb.BinarySearch;
import ca.uwaterloo.cs.ql.fb.IDManager;
import ca.uwaterloo.cs.ql.fb.Node;
import ca.uwaterloo.cs.ql.fb.RadixSorter;
import ca.uwaterloo.cs.ql.fb.Tuple;
import ca.uwaterloo.cs.ql.fb.Tuple4Node;
import ca.uwaterloo.cs.ql.fb.TupleList;
import ca.uwaterloo.cs.ql.fb.TupleListFactory;
import ca.uwaterloo.cs.ql.fb.TupleSet;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;

public class NodeSet
extends TupleSet {
    public NodeSet() {
        this.data = TupleListFactory.newNodeList();
    }

    public NodeSet(String string) {
        super(string);
        this.data = TupleListFactory.newNodeList();
    }

    public NodeSet(int n) {
        this.data = TupleListFactory.newNodeList(n);
    }

    public static NodeSet singleton(int n) {
        NodeSet nodeSet = new NodeSet(1);
        nodeSet.data.add(new Tuple4Node(n));
        nodeSet.unsetFlag(4);
        nodeSet.sortLevel = 0;
        return nodeSet;
    }

    public static NodeSet singleton(String string) {
        NodeSet nodeSet = new NodeSet(1);
        nodeSet.add(string);
        nodeSet.sortLevel = 0;
        nodeSet.unsetFlag(4);
        return nodeSet;
    }

    public void add(int n) {
        this.data.add(new Tuple4Node(n));
        this.sortLevel = -1;
        this.flags = 0;
    }

    public void add(String string) {
        this.data.add(new Tuple4Node(IDManager.getID(string)));
        this.sortLevel = -1;
        this.flags = 0;
    }

    public TupleSet newSet() {
        return new NodeSet();
    }

    public boolean contain(String string) {
        this.trySort(0);
        return BinarySearch.search(this.data, IDManager.getID(string), 0) > -1;
    }

    public String pick() {
        int n = (int)(Math.random() * (double)this.data.size());
        int n2 = this.data.get(n).getDom();
        return IDManager.get(n2);
    }

    public NodeSet pick(int n) {
        int n2 = this.data.size();
        if (n < 1) {
            return new NodeSet();
        }
        if (n >= n2) {
            return (NodeSet)this.clone();
        }
        NodeSet nodeSet = new NodeSet();
        boolean bl = false;
        int n3 = n2 / n;
        if (n3 == 1) {
            bl = true;
            n = n2 - n;
            n3 = n2 / n;
        }
        for (int i = 0; i < n; ++i) {
            int n4 = (int)(Math.random() * (double)n3);
            int n5 = i * n3 + n4;
            nodeSet.add(this.data.get(n5).getDom());
        }
        if (bl) {
            nodeSet = AlgebraOperation.difference(this, nodeSet);
        }
        return nodeSet;
    }

    public Node pickNode() {
        int n = (int)(Math.random() * (double)this.data.size());
        int n2 = this.data.get(n).getDom();
        return new Node(n2);
    }

    public Node[] getAllNodes() {
        int n = this.data.size();
        Node[] nodeArray = new Node[n];
        for (int i = 0; i < n; ++i) {
            nodeArray[i] = new Node(this.data.get(i).getDom());
        }
        return nodeArray;
    }

    public void print(OutputStream outputStream) {
        PrintWriter printWriter = new PrintWriter(outputStream, true);
        int n = this.data.size();
        for (int i = 0; i < n; ++i) {
            Tuple tuple = this.data.get(i);
            printWriter.println(IDManager.get(tuple.getDom()));
        }
        printWriter.flush();
    }

    public void printTA(OutputStream outputStream) {
        int n = "$INSTANCE ".length();
        StringBuffer stringBuffer = new StringBuffer("$INSTANCE ");
        PrintWriter printWriter = new PrintWriter(outputStream, true);
        int n2 = this.data.size();
        for (int i = 0; i < n2; ++i) {
            Tuple tuple = this.data.get(i);
            stringBuffer.delete(n, stringBuffer.length());
            stringBuffer.append(IDManager.get(tuple.getDom()));
            stringBuffer.append(' ');
            stringBuffer.append(this.getName());
            printWriter.println(stringBuffer);
        }
        printWriter.flush();
    }

    public void appendTA(String string) throws IOException {
        int n = "$INSTANCE ".length();
        StringBuffer stringBuffer = new StringBuffer("$INSTANCE ");
        RandomAccessFile randomAccessFile = new RandomAccessFile(new File(string), "rw");
        randomAccessFile.seek(randomAccessFile.length());
        int n2 = this.data.size();
        if (n2 > 0) {
            randomAccessFile.writeBytes("FACT TUPLE :\n");
        }
        for (int i = 0; i < n2; ++i) {
            Tuple tuple = this.data.get(i);
            stringBuffer.delete(n, stringBuffer.length());
            stringBuffer.append(IDManager.get(tuple.getDom()));
            stringBuffer.append(' ');
            stringBuffer.append(this.getName());
            randomAccessFile.writeBytes(stringBuffer + "\n");
        }
        randomAccessFile.close();
    }

    public void prefixCat(String string) {
        int n = this.data.size();
        for (int i = 0; i < n; ++i) {
            Tuple tuple = this.data.get(i);
            int n2 = tuple.getDom();
            n2 = IDManager.getID(string + IDManager.get(n2));
            tuple.setDom(n2);
        }
        this.sortLevel = -1;
    }

    public void suffixCat(String string) {
        int n = this.data.size();
        for (int i = 0; i < n; ++i) {
            Tuple tuple = this.data.get(i);
            int n2 = tuple.getDom();
            n2 = IDManager.getID(IDManager.get(n2) + string);
            tuple.setDom(n2);
        }
        this.sortLevel = -1;
    }

    protected void sort() {
        this.trySort(0);
    }

    protected void sortDom() {
        this.trySort(0);
    }

    protected void sortRng() {
        this.trySort(0);
    }

    protected void trySort(int n) {
        int n2 = 0;
        switch (n) {
            case 0: {
                if (this.sortLevel >= 0) break;
                TupleList tupleList = TupleListFactory.newNodeList(this.data.size());
                RadixSorter.sort(this.data, n2, tupleList);
                this.data.setList(tupleList.getList());
                this.sortLevel = 0;
                break;
            }
            default: {
                this.trySort(0);
            }
        }
    }
}

