/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.ql.fb;

import ca.uwaterloo.cs.ql.fb.EdgeSet;
import ca.uwaterloo.cs.ql.fb.NodeSet;
import ca.uwaterloo.cs.ql.fb.StringTable;
import java.util.StringTokenizer;

public final class IDManager {
    static StringTable strTable;
    private static StringBuffer dataBuffer;

    public static int getID(Object object) {
        return IDManager.getID(object.toString());
    }

    public static int getID(String string) {
        return strTable.add(string);
    }

    public static String get(int n) {
        String string = strTable.get(n);
        if (strTable.isComposite(n)) {
            return IDManager.parse(string);
        }
        return string;
    }

    public static boolean isComposite(int n) {
        return strTable.isComposite(n);
    }

    public static int[] parse(int n) {
        int[] nArray;
        if (strTable.isComposite(n)) {
            String string = strTable.get(n);
            StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
            nArray = new int[stringTokenizer.countTokens()];
            int n2 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                try {
                    nArray[n2] = Integer.parseInt(stringTokenizer.nextToken());
                    ++n2;
                }
                catch (NumberFormatException numberFormatException) {
                    nArray = new int[]{n};
                    break;
                }
            }
        } else {
            nArray = new int[]{n};
        }
        return nArray;
    }

    public static int getID(int[] nArray) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; n < nArray.length; ++n) {
            stringBuffer.append(nArray[n]);
            stringBuffer.append(":");
        }
        if (n > 1) {
            stringBuffer.delete(stringBuffer.length() - 1, stringBuffer.length());
        }
        return strTable.addComposite(stringBuffer.toString());
    }

    public static int getID(int n, int n2) {
        return strTable.addComposite(n + ":" + n2);
    }

    public static int getID(int n, int n2, int n3) {
        return strTable.addComposite(n + ":" + n2 + ":" + n3);
    }

    public static int getReplaceID(int n) {
        if (strTable.isComposite(n)) {
            int[] nArray = IDManager.parse(n);
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = IDManager.getReplaceID(nArray[i]);
            }
            return IDManager.getID(nArray);
        }
        return strTable.getReplace(n);
    }

    public static EdgeSet getID() {
        EdgeSet edgeSet = new EdgeSet();
        edgeSet.data = strTable.getID();
        edgeSet.sortLevel = 2;
        return edgeSet;
    }

    public static NodeSet getENT() {
        NodeSet nodeSet = new NodeSet();
        nodeSet.data = strTable.getENT();
        nodeSet.sortLevel = 0;
        return nodeSet;
    }

    public static NodeSet getAllCompositeIDs() {
        NodeSet nodeSet = new NodeSet();
        nodeSet.data = strTable.getAllComposites();
        return nodeSet;
    }

    private static String parse(String string) {
        dataBuffer.delete(0, dataBuffer.length());
        dataBuffer.append('(');
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        while (stringTokenizer.hasMoreTokens()) {
            try {
                int n = Integer.parseInt(stringTokenizer.nextToken());
                dataBuffer.append(IDManager.get(n));
                dataBuffer.append(' ');
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        dataBuffer.delete(dataBuffer.length() - 1, dataBuffer.length());
        dataBuffer.append(')');
        return dataBuffer.toString();
    }

    static {
        dataBuffer = new StringBuffer();
        strTable = StringTable.instance();
    }
}

